"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantVisibility = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _aiAssistantCommon = require("@kbn/ai-assistant-common");
var _settings_context = require("../../contexts/settings_context");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/gen_ai_settings/public/components/ai_assistant_visibility/ai_assistant_visibility.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AIAssistantVisibility = () => {
  var _application$capabili, _application$capabili2, _ref, _unsavedChanges$AI_CH, _unsavedChanges$AI_CH2, _application$capabili3;
  const {
    fields,
    handleFieldChange,
    unsavedChanges
  } = (0, _settings_context.useSettingsContext)();
  const {
    services: {
      settings,
      notifications,
      docLinks,
      application
    }
  } = (0, _use_kibana.useKibana)();
  const field = fields[_managementSettingsIds.AI_ASSISTANT_PREFERRED_AI_ASSISTANT_TYPE];
  const chatExperienceField = fields[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE];
  if (!field) return null;
  const hasObservabilityAssistant = ((_application$capabili = application.capabilities.observabilityAIAssistant) === null || _application$capabili === void 0 ? void 0 : _application$capabili.show) === true;
  const hasSecurityAssistant = ((_application$capabili2 = application.capabilities.securitySolutionAssistant) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2['ai-assistant']) === true;

  // Hide if user doesn't have any assistant capabilities
  if (!hasObservabilityAssistant && !hasSecurityAssistant) {
    return null;
  }
  const currentChatExperience = (_ref = (_unsavedChanges$AI_CH = (_unsavedChanges$AI_CH2 = unsavedChanges[_managementSettingsIds.AI_CHAT_EXPERIENCE_TYPE]) === null || _unsavedChanges$AI_CH2 === void 0 ? void 0 : _unsavedChanges$AI_CH2.unsavedValue) !== null && _unsavedChanges$AI_CH !== void 0 ? _unsavedChanges$AI_CH : chatExperienceField === null || chatExperienceField === void 0 ? void 0 : chatExperienceField.savedValue) !== null && _ref !== void 0 ? _ref : _aiAssistantCommon.AIChatExperience.Classic;

  // Hide AI Assistant Visibility when AI Agent is selected
  if (currentChatExperience === _aiAssistantCommon.AIChatExperience.Agent) {
    return null;
  }
  const canEditAdvancedSettings = (_application$capabili3 = application.capabilities.advancedSettings) === null || _application$capabili3 === void 0 ? void 0 : _application$capabili3.save;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
    links: docLinks.links.management,
    showDanger: message => notifications.toasts.addDanger(message),
    validateChange: (key, value) => settings.client.validateValue(key, value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRow, {
    field: field,
    isSavingEnabled: !!canEditAdvancedSettings,
    onFieldChange: handleFieldChange,
    unsavedChange: unsavedChanges[_managementSettingsIds.AI_ASSISTANT_PREFERRED_AI_ASSISTANT_TYPE],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })));
};
exports.AIAssistantVisibility = AIAssistantVisibility;