"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAgentRequestSchema = exports.PostRetrieveAgentsByActionsResponseSchema = exports.PostRetrieveAgentsByActionsRequestSchema = exports.PostRequestDiagnosticsActionRequestSchema = exports.PostNewAgentActionResponseSchema = exports.PostNewAgentActionRequestSchema = exports.PostCancelActionRequestSchema = exports.PostBulkUpdateAgentTagsRequestSchema = exports.PostBulkRequestDiagnosticsActionRequestSchema = exports.PostBulkAgentUpgradeRequestSchema = exports.PostBulkAgentUnenrollRequestSchema = exports.PostBulkAgentReassignRequestSchema = exports.PostBulkActionResponseSchema = exports.PostAgentUpgradeRequestSchema = exports.PostAgentUnenrollRequestSchema = exports.PostAgentReassignRequestSchema = exports.MigrateSingleAgentResponseSchema = exports.MigrateSingleAgentRequestSchema = exports.MigrateOptionsSchema = exports.ListAgentUploadsResponseSchema = exports.ListAgentUploadsRequestSchema = exports.GetOneAgentRequestSchema = exports.GetAvailableAgentVersionsResponseSchema = exports.GetAgentsResponseSchema = exports.GetAgentsRequestSchema = exports.GetAgentUploadFileRequestSchema = exports.GetAgentStatusResponseSchema = exports.GetAgentStatusRequestSchema = exports.GetAgentResponseSchema = exports.GetAgentDataResponseSchema = exports.GetAgentDataRequestSchema = exports.GetActionStatusResponseSchema = exports.GetActionStatusRequestSchema = exports.DeleteAgentUploadFileResponseSchema = exports.DeleteAgentUploadFileRequestSchema = exports.DeleteAgentResponseSchema = exports.DeleteAgentRequestSchema = exports.ChangeAgentPrivilegeLevelResponseSchema = exports.ChangeAgentPrivilegeLevelRequestSchema = exports.BulkMigrateOptionsSchema = exports.BulkMigrateAgentsResponseSchema = exports.BulkMigrateAgentsRequestSchema = exports.BulkChangeAgentsPrivilegeLevelRequestSchema = exports.AgentUpgradeStateTypeSchema = exports.AgentStatusSchema = exports.AgentResponseSchema = exports.AgentComponentStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _moment = _interopRequireDefault(require("moment"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _types = require("../../../common/types");
var _constants = require("../../constants");
var _models = require("../models");
var _filter_utils = require("../../routes/utils/filter_utils");
var _utils = require("../../routes/schema/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetAgentsRequestSchema = exports.GetAgentsRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.maybe(_configSchema.schema.number()),
    perPage: _configSchema.schema.number({
      defaultValue: 20
    }),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => {
        const validationObj = (0, _filter_utils.validateKuery)(value, [_constants.AGENTS_PREFIX], _constants.AGENT_MAPPINGS, true);
        if (validationObj !== null && validationObj !== void 0 && validationObj.error) {
          return validationObj === null || validationObj === void 0 ? void 0 : validationObj.error;
        }
      }
    })),
    showAgentless: _configSchema.schema.boolean({
      defaultValue: true
    }),
    showInactive: _configSchema.schema.boolean({
      defaultValue: false
    }),
    withMetrics: _configSchema.schema.boolean({
      defaultValue: false
    }),
    showUpgradeable: _configSchema.schema.boolean({
      defaultValue: false
    }),
    getStatusSummary: _configSchema.schema.boolean({
      defaultValue: false
    }),
    sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
    sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
    searchAfter: _configSchema.schema.maybe(_configSchema.schema.string()),
    openPit: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    pitId: _configSchema.schema.maybe(_configSchema.schema.string()),
    pitKeepAlive: _configSchema.schema.maybe(_configSchema.schema.string())
  }, {
    validate: request => {
      const usingSearchAfter = !!request.searchAfter;
      const usingPIT = !!(request.openPit || request.pitId || request.pitKeepAlive);

      // If using PIT search, ensure that all required PIT parameters are provided
      if (usingPIT) {
        if (request.openPit && request.pitId) {
          return 'You cannot request to open a new point-in-time with an existing pitId';
        }
        if (!request.pitKeepAlive) {
          return 'You must provide pitKeepAlive when using point-in-time parameters';
        }
      }

      // Ensure that pagination parameters are not over the search limit
      if ((request.page || 1) * request.perPage > _constants.SO_SEARCH_LIMIT) {
        return `You cannot use page and perPage page over ${_constants.SO_SEARCH_LIMIT} agents`;
      }

      // If using searchAfter:
      //   1. ensure that incompatible pagination parameters are not used
      //   2. ensure that searchAfter is an array
      if (usingSearchAfter) {
        if (request.page) {
          return 'You cannot use page parameter when using searchAfter';
        }
        // ensure that searchAfter is an array after parsing json
        try {
          const searchAfterArray = JSON.parse(request.searchAfter);
          if (!Array.isArray(searchAfterArray) || searchAfterArray.length === 0) {
            return 'searchAfter must be a non-empty array';
          }
        } catch (e) {
          return 'searchAfter must be a non-empty array';
        }
      }
    }
  })
};
const MigrateOptionsSchema = exports.MigrateOptionsSchema = {
  ca_sha256: _configSchema.schema.maybe(_configSchema.schema.string()),
  certificate_authorities: _configSchema.schema.maybe(_configSchema.schema.string()),
  elastic_agent_cert: _configSchema.schema.maybe(_configSchema.schema.string()),
  elastic_agent_cert_key: _configSchema.schema.maybe(_configSchema.schema.string()),
  elastic_agent_cert_key_passphrase: _configSchema.schema.maybe(_configSchema.schema.string()),
  headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
  insecure: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  proxy_disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  proxy_headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
  proxy_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  staging: _configSchema.schema.maybe(_configSchema.schema.string()),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  replace_token: _configSchema.schema.maybe(_configSchema.schema.string())
};
const BulkMigrateOptionsSchema = exports.BulkMigrateOptionsSchema = {
  ca_sha256: _configSchema.schema.maybe(_configSchema.schema.string()),
  certificate_authorities: _configSchema.schema.maybe(_configSchema.schema.string()),
  elastic_agent_cert: _configSchema.schema.maybe(_configSchema.schema.string()),
  elastic_agent_cert_key: _configSchema.schema.maybe(_configSchema.schema.string()),
  elastic_agent_cert_key_passphrase: _configSchema.schema.maybe(_configSchema.schema.string()),
  headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
  insecure: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  proxy_disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  proxy_headers: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.string())),
  proxy_url: _configSchema.schema.maybe(_configSchema.schema.string()),
  staging: _configSchema.schema.maybe(_configSchema.schema.string()),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
};
const AgentComponentStateSchema = exports.AgentComponentStateSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('STARTING'), _configSchema.schema.literal('CONFIGURING'), _configSchema.schema.literal('HEALTHY'), _configSchema.schema.literal('DEGRADED'), _configSchema.schema.literal('FAILED'), _configSchema.schema.literal('STOPPING'), _configSchema.schema.literal('STOPPED')]);
const AgentUpgradeStateTypeSchema = exports.AgentUpgradeStateTypeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('UPG_REQUESTED'), _configSchema.schema.literal('UPG_SCHEDULED'), _configSchema.schema.literal('UPG_DOWNLOADING'), _configSchema.schema.literal('UPG_EXTRACTING'), _configSchema.schema.literal('UPG_REPLACING'), _configSchema.schema.literal('UPG_RESTARTING'), _configSchema.schema.literal('UPG_FAILED'), _configSchema.schema.literal('UPG_WATCHING'), _configSchema.schema.literal('UPG_ROLLBACK')]);
const AgentStatusSchema = exports.AgentStatusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('offline'), _configSchema.schema.literal('error'), _configSchema.schema.literal('online'), _configSchema.schema.literal('inactive'), _configSchema.schema.literal('enrolling'), _configSchema.schema.literal('unenrolling'), _configSchema.schema.literal('unenrolled'), _configSchema.schema.literal('updating'), _configSchema.schema.literal('degraded'), _configSchema.schema.literal('uninstalled'), _configSchema.schema.literal('orphaned')]);
const AgentResponseSchema = exports.AgentResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  access_api_key: _configSchema.schema.maybe(_configSchema.schema.string()),
  default_api_key_history: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    retired_at: _configSchema.schema.string()
  }, {
    meta: {
      deprecated: true
    }
  }))),
  outputs: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    api_key_id: _configSchema.schema.maybe(_configSchema.schema.string()),
    type: _configSchema.schema.maybe(_configSchema.schema.string()),
    to_retire_api_key_ids: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      retired_at: _configSchema.schema.string()
    })))
  }))),
  status: _configSchema.schema.maybe(AgentStatusSchema),
  last_known_status: _configSchema.schema.maybe(AgentStatusSchema),
  packages: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  sort: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.any())),
  // ES can return many different types for `sort` array values, including unsafe numbers
  metrics: _configSchema.schema.maybe(_configSchema.schema.object({
    cpu_avg: _configSchema.schema.maybe(_configSchema.schema.number()),
    memory_size_byte_avg: _configSchema.schema.maybe(_configSchema.schema.number())
  })),
  type: _configSchema.schema.oneOf([_configSchema.schema.literal('PERMANENT'), _configSchema.schema.literal('EPHEMERAL'), _configSchema.schema.literal('TEMPORARY')]),
  active: _configSchema.schema.boolean(),
  enrolled_at: _configSchema.schema.string(),
  unenrolled_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  unenrollment_started_at: _configSchema.schema.maybe(_configSchema.schema.string()),
  audit_unenrolled_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
  upgraded_at: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  upgrade_started_at: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string()])),
  upgrade_details: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.object({
    target_version: _configSchema.schema.string(),
    action_id: _configSchema.schema.string(),
    state: AgentUpgradeStateTypeSchema,
    metadata: _configSchema.schema.maybe(_configSchema.schema.object({
      scheduled_at: _configSchema.schema.maybe(_configSchema.schema.string()),
      download_percent: _configSchema.schema.maybe(_configSchema.schema.number()),
      download_rate: _configSchema.schema.maybe(_configSchema.schema.number()),
      failed_state: _configSchema.schema.maybe(AgentUpgradeStateTypeSchema),
      error_msg: _configSchema.schema.maybe(_configSchema.schema.string()),
      retry_error_msg: _configSchema.schema.maybe(_configSchema.schema.string()),
      retry_until: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  })])),
  upgrade_attempts: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.arrayOf(_configSchema.schema.string())])),
  access_api_key_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  default_api_key: _configSchema.schema.maybe(_configSchema.schema.string()),
  default_api_key_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  policy_id: _configSchema.schema.maybe(_configSchema.schema.string()),
  policy_revision: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.number()])),
  last_checkin: _configSchema.schema.maybe(_configSchema.schema.string()),
  last_checkin_status: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('error'), _configSchema.schema.literal('online'), _configSchema.schema.literal('degraded'), _configSchema.schema.literal('updating'), _configSchema.schema.literal('starting')])),
  last_checkin_message: _configSchema.schema.maybe(_configSchema.schema.string()),
  user_provided_metadata: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  local_metadata: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
  tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  components: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    status: AgentComponentStateSchema,
    message: _configSchema.schema.string(),
    units: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      type: _configSchema.schema.oneOf([_configSchema.schema.literal('input'), _configSchema.schema.literal('output'), _configSchema.schema.literal('')]),
      status: AgentComponentStateSchema,
      message: _configSchema.schema.string(),
      payload: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
    })))
  }))),
  agent: _configSchema.schema.maybe(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    version: _configSchema.schema.string()
  }).extendsDeep({
    unknowns: 'allow'
  })),
  unhealthy_reason: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('input'), _configSchema.schema.literal('output'), _configSchema.schema.literal('other')]))])),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const GetAgentsResponseSchema = exports.GetAgentsResponseSchema = (0, _utils.ListResponseSchema)(AgentResponseSchema).extends({
  pit: _configSchema.schema.maybe(_configSchema.schema.string()),
  nextSearchAfter: _configSchema.schema.maybe(_configSchema.schema.string()),
  statusSummary: _configSchema.schema.maybe(_configSchema.schema.recordOf(AgentStatusSchema, _configSchema.schema.number()))
});
const GetAgentResponseSchema = exports.GetAgentResponseSchema = _configSchema.schema.object({
  item: AgentResponseSchema
});
const GetOneAgentRequestSchema = exports.GetOneAgentRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  query: _configSchema.schema.object({
    withMetrics: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const PostNewAgentActionRequestSchema = exports.PostNewAgentActionRequestSchema = {
  body: _configSchema.schema.object({
    action: _models.NewAgentActionSchema
  }),
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  })
};
const PostNewAgentActionResponseSchema = exports.PostNewAgentActionResponseSchema = _configSchema.schema.object({
  item: _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    // literals
    data: _configSchema.schema.maybe(_configSchema.schema.any()),
    sent_at: _configSchema.schema.maybe(_configSchema.schema.string()),
    created_at: _configSchema.schema.string(),
    ack_data: _configSchema.schema.maybe(_configSchema.schema.any()),
    agents: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
    start_time: _configSchema.schema.maybe(_configSchema.schema.string()),
    minimum_execution_duration: _configSchema.schema.maybe(_configSchema.schema.number()),
    rollout_duration_seconds: _configSchema.schema.maybe(_configSchema.schema.number()),
    source_uri: _configSchema.schema.maybe(_configSchema.schema.string()),
    total: _configSchema.schema.maybe(_configSchema.schema.number())
  })
});
const PostCancelActionRequestSchema = exports.PostCancelActionRequestSchema = {
  params: _configSchema.schema.object({
    actionId: _configSchema.schema.string()
  })
};
const PostRetrieveAgentsByActionsRequestSchema = exports.PostRetrieveAgentsByActionsRequestSchema = {
  body: _configSchema.schema.object({
    actionIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
  })
};
const PostRetrieveAgentsByActionsResponseSchema = exports.PostRetrieveAgentsByActionsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const PostAgentUnenrollRequestSchema = exports.PostAgentUnenrollRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    revoke: _configSchema.schema.maybe(_configSchema.schema.boolean())
  }))
};
const PostBulkAgentUnenrollRequestSchema = exports.PostBulkAgentUnenrollRequestSchema = {
  body: _configSchema.schema.object({
    agents: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string({
      meta: {
        description: 'KQL query string, leave empty to action all agents'
      }
    })), _configSchema.schema.string({
      meta: {
        description: 'list of agent IDs'
      }
    })]),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'Unenrolls hosted agents too'
      }
    })),
    revoke: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'Revokes API keys of agents'
      }
    })),
    batchSize: _configSchema.schema.maybe(_configSchema.schema.number()),
    includeInactive: _configSchema.schema.maybe(_configSchema.schema.boolean({
      meta: {
        description: 'When passing agents by KQL query, unenrolls inactive agents too'
      }
    }))
  })
};
function validateVersion(s) {
  if (!(0, _valid.default)(s)) {
    return 'not a valid semver';
  }
}
const PostAgentUpgradeRequestSchema = exports.PostAgentUpgradeRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.object({
    source_uri: _configSchema.schema.maybe(_configSchema.schema.string()),
    version: _configSchema.schema.string({
      validate: validateVersion
    }),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    skipRateLimitCheck: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const PostBulkAgentUpgradeRequestSchema = exports.PostBulkAgentUpgradeRequestSchema = {
  body: _configSchema.schema.object({
    agents: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
    source_uri: _configSchema.schema.maybe(_configSchema.schema.string()),
    version: _configSchema.schema.string({
      validate: validateVersion
    }),
    force: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    skipRateLimitCheck: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    rollout_duration_seconds: _configSchema.schema.maybe(_configSchema.schema.number({
      min: 600
    })),
    start_time: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: v => {
        if (!(0, _moment.default)(v).isValid()) {
          return 'not a valid date';
        }
      }
    })),
    batchSize: _configSchema.schema.maybe(_configSchema.schema.number()),
    includeInactive: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const PostAgentReassignRequestSchema = exports.PostAgentReassignRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.object({
    policy_id: _configSchema.schema.string()
  })
};
const PostRequestDiagnosticsActionRequestSchema = exports.PostRequestDiagnosticsActionRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    additional_metrics: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_types.RequestDiagnosticsAdditionalMetrics.CPU)])))
  }))
};
const PostBulkRequestDiagnosticsActionRequestSchema = exports.PostBulkRequestDiagnosticsActionRequestSchema = {
  body: _configSchema.schema.object({
    agents: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
    batchSize: _configSchema.schema.maybe(_configSchema.schema.number()),
    additional_metrics: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_types.RequestDiagnosticsAdditionalMetrics.CPU)])))
  })
};
const ListAgentUploadsRequestSchema = exports.ListAgentUploadsRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  })
};
const ListAgentUploadsResponseSchema = exports.ListAgentUploadsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    filePath: _configSchema.schema.string(),
    createTime: _configSchema.schema.string(),
    status: _configSchema.schema.oneOf([_configSchema.schema.literal('READY'), _configSchema.schema.literal('AWAITING_UPLOAD'), _configSchema.schema.literal('DELETED'), _configSchema.schema.literal('EXPIRED'), _configSchema.schema.literal('IN_PROGRESS'), _configSchema.schema.literal('FAILED')]),
    actionId: _configSchema.schema.string(),
    error: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});
const GetAgentUploadFileRequestSchema = exports.GetAgentUploadFileRequestSchema = {
  params: _configSchema.schema.object({
    fileId: _configSchema.schema.string(),
    fileName: _configSchema.schema.string()
  })
};
const DeleteAgentUploadFileRequestSchema = exports.DeleteAgentUploadFileRequestSchema = {
  params: _configSchema.schema.object({
    fileId: _configSchema.schema.string()
  })
};
const DeleteAgentUploadFileResponseSchema = exports.DeleteAgentUploadFileResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  deleted: _configSchema.schema.boolean()
});
const PostBulkAgentReassignRequestSchema = exports.PostBulkAgentReassignRequestSchema = {
  body: _configSchema.schema.object({
    policy_id: _configSchema.schema.string(),
    agents: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
    batchSize: _configSchema.schema.maybe(_configSchema.schema.number()),
    includeInactive: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const DeleteAgentRequestSchema = exports.DeleteAgentRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  })
};
const DeleteAgentResponseSchema = exports.DeleteAgentResponseSchema = _configSchema.schema.object({
  action: _configSchema.schema.literal('deleted')
});
const UpdateAgentRequestSchema = exports.UpdateAgentRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.object({
    user_provided_metadata: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
    tags: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  })
};
const MigrateSingleAgentRequestSchema = exports.MigrateSingleAgentRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.object({
    uri: _configSchema.schema.uri(),
    enrollment_token: _configSchema.schema.string(),
    settings: _configSchema.schema.maybe(_configSchema.schema.object(MigrateOptionsSchema))
  })
};
const MigrateSingleAgentResponseSchema = exports.MigrateSingleAgentResponseSchema = _configSchema.schema.object({
  actionId: _configSchema.schema.string()
});
const BulkMigrateAgentsRequestSchema = exports.BulkMigrateAgentsRequestSchema = {
  body: _configSchema.schema.object({
    agents: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
    uri: _configSchema.schema.uri(),
    enrollment_token: _configSchema.schema.string(),
    settings: _configSchema.schema.maybe(_configSchema.schema.object(BulkMigrateOptionsSchema)),
    batchSize: _configSchema.schema.maybe(_configSchema.schema.number())
  })
};
const BulkMigrateAgentsResponseSchema = exports.BulkMigrateAgentsResponseSchema = _configSchema.schema.object({
  actionId: _configSchema.schema.string()
});
const PostBulkUpdateAgentTagsRequestSchema = exports.PostBulkUpdateAgentTagsRequestSchema = {
  body: _configSchema.schema.object({
    agents: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
    tagsToAdd: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    tagsToRemove: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    batchSize: _configSchema.schema.maybe(_configSchema.schema.number()),
    includeInactive: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const PostBulkActionResponseSchema = exports.PostBulkActionResponseSchema = _configSchema.schema.object({
  actionId: _configSchema.schema.string()
});
const GetAgentStatusRequestSchema = exports.GetAgentStatusRequestSchema = {
  query: _configSchema.schema.object({
    policyId: _configSchema.schema.maybe(_configSchema.schema.string()),
    policyIds: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()])),
    kuery: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: value => {
        const validationObj = (0, _filter_utils.validateKuery)(value, [_constants.AGENTS_PREFIX], _constants.AGENT_MAPPINGS, true);
        if (validationObj !== null && validationObj !== void 0 && validationObj.error) {
          return validationObj === null || validationObj === void 0 ? void 0 : validationObj.error;
        }
      }
    }))
  })
};
const GetAgentStatusResponseSchema = exports.GetAgentStatusResponseSchema = _configSchema.schema.object({
  results: _configSchema.schema.object({
    events: _configSchema.schema.number(),
    online: _configSchema.schema.number(),
    error: _configSchema.schema.number(),
    offline: _configSchema.schema.number(),
    uninstalled: _configSchema.schema.maybe(_configSchema.schema.number()),
    orphaned: _configSchema.schema.maybe(_configSchema.schema.number()),
    other: _configSchema.schema.number(),
    updating: _configSchema.schema.number(),
    inactive: _configSchema.schema.number(),
    unenrolled: _configSchema.schema.number(),
    all: _configSchema.schema.number(),
    active: _configSchema.schema.number()
  })
});
const GetAgentDataRequestSchema = exports.GetAgentDataRequestSchema = {
  query: _configSchema.schema.object({
    agentsIds: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
    pkgName: _configSchema.schema.maybe(_configSchema.schema.string()),
    pkgVersion: _configSchema.schema.maybe(_configSchema.schema.string()),
    previewData: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const GetAgentDataResponseSchema = exports.GetAgentDataResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
    data: _configSchema.schema.boolean()
  }))),
  dataPreview: _configSchema.schema.arrayOf(_configSchema.schema.any())
});
const GetActionStatusRequestSchema = exports.GetActionStatusRequestSchema = {
  query: _configSchema.schema.object({
    page: _configSchema.schema.number({
      defaultValue: 0
    }),
    perPage: _configSchema.schema.number({
      defaultValue: 20
    }),
    date: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: v => {
        if (!(0, _moment.default)(v).isValid()) {
          return 'not a valid date';
        }
      }
    })),
    latest: _configSchema.schema.maybe(_configSchema.schema.number()),
    errorSize: _configSchema.schema.number({
      defaultValue: 5
    })
  })
};
const GetActionStatusResponseSchema = exports.GetActionStatusResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.object({
    actionId: _configSchema.schema.string(),
    is_automatic: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    nbAgentsActionCreated: _configSchema.schema.number({
      meta: {
        description: 'number of agents included in action from kibana'
      }
    }),
    nbAgentsAck: _configSchema.schema.number({
      meta: {
        description: 'number of agents that acknowledged the action'
      }
    }),
    nbAgentsFailed: _configSchema.schema.number({
      meta: {
        description: 'number of agents that failed to execute the action'
      }
    }),
    version: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'agent version number (UPGRADE action)'
      }
    })),
    startTime: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'start time of action (scheduled actions)'
      }
    })),
    type: _configSchema.schema.oneOf([_configSchema.schema.literal('UPGRADE'), _configSchema.schema.literal('UNENROLL'), _configSchema.schema.literal('SETTINGS'), _configSchema.schema.literal('POLICY_REASSIGN'), _configSchema.schema.literal('CANCEL'), _configSchema.schema.literal('FORCE_UNENROLL'), _configSchema.schema.literal('REQUEST_DIAGNOSTICS'), _configSchema.schema.literal('UPDATE_TAGS'), _configSchema.schema.literal('POLICY_CHANGE'), _configSchema.schema.literal('INPUT_ACTION'), _configSchema.schema.literal('MIGRATE'), _configSchema.schema.literal('PRIVILEGE_LEVEL_CHANGE')]),
    nbAgentsActioned: _configSchema.schema.number({
      meta: {
        description: 'number of agents actioned'
      }
    }),
    status: _configSchema.schema.oneOf([_configSchema.schema.literal('COMPLETE'), _configSchema.schema.literal('EXPIRED'), _configSchema.schema.literal('CANCELLED'), _configSchema.schema.literal('FAILED'), _configSchema.schema.literal('IN_PROGRESS'), _configSchema.schema.literal('ROLLOUT_PASSED')]),
    expiration: _configSchema.schema.maybe(_configSchema.schema.string()),
    completionTime: _configSchema.schema.maybe(_configSchema.schema.string()),
    cancellationTime: _configSchema.schema.maybe(_configSchema.schema.string()),
    newPolicyId: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'new policy id (POLICY_REASSIGN action)'
      }
    })),
    creationTime: _configSchema.schema.string({
      meta: {
        description: 'creation time of action'
      }
    }),
    hasRolloutPeriod: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    latestErrors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
      agentId: _configSchema.schema.string(),
      error: _configSchema.schema.string(),
      timestamp: _configSchema.schema.string(),
      hostname: _configSchema.schema.maybe(_configSchema.schema.string())
    }, {
      meta: {
        description: 'latest errors that happened when the agents executed the action'
      }
    }))),
    revision: _configSchema.schema.maybe(_configSchema.schema.number({
      meta: {
        description: 'new policy revision (POLICY_CHANGE action)'
      }
    })),
    policyId: _configSchema.schema.maybe(_configSchema.schema.string({
      meta: {
        description: 'policy id (POLICY_CHANGE action)'
      }
    }))
  }))
});
const GetAvailableAgentVersionsResponseSchema = exports.GetAvailableAgentVersionsResponseSchema = _configSchema.schema.object({
  items: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const ChangeAgentPrivilegeLevelRequestSchema = exports.ChangeAgentPrivilegeLevelRequestSchema = {
  params: _configSchema.schema.object({
    agentId: _configSchema.schema.string()
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    user_info: _configSchema.schema.maybe(_configSchema.schema.object({
      username: _configSchema.schema.maybe(_configSchema.schema.string()),
      groupname: _configSchema.schema.maybe(_configSchema.schema.string()),
      password: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  }))
};

/**
 * Returns an object with either the actionId (if an action was created),
 * or an information message (if no action was needed).
 */
const ChangeAgentPrivilegeLevelResponseSchema = exports.ChangeAgentPrivilegeLevelResponseSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  actionId: _configSchema.schema.string()
}), _configSchema.schema.object({
  message: _configSchema.schema.string()
})]);
const BulkChangeAgentsPrivilegeLevelRequestSchema = exports.BulkChangeAgentsPrivilegeLevelRequestSchema = {
  body: _configSchema.schema.object({
    agents: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
    batchSize: _configSchema.schema.maybe(_configSchema.schema.number()),
    user_info: _configSchema.schema.maybe(_configSchema.schema.object({
      username: _configSchema.schema.maybe(_configSchema.schema.string()),
      groupname: _configSchema.schema.maybe(_configSchema.schema.string()),
      password: _configSchema.schema.maybe(_configSchema.schema.string())
    }))
  })
};