"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkAllowedPackages = checkAllowedPackages;
var _lodash = require("lodash");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function checkAllowedPackages(packages, allowedPackages, keyPath = '') {
  // allowedPackages is undefined when user has privileges from fleet
  if (!packages.length || !allowedPackages) {
    return;
  }
  if (!allowedPackages.length) {
    throw new _errors.FleetUnauthorizedError('Authorization denied due to lack of integration package privileges');
  }
  const allowedPackagedSet = new Set(allowedPackages);
  const allowedPackagesStr = allowedPackages.join(', ');
  packages.some(pkg => {
    const pkgName = typeof pkg === 'string' ? pkg : (0, _lodash.get)(pkg, keyPath, undefined);
    if (!pkgName) {
      throw new _errors.FleetUnauthorizedError(`Authorization denied. Allowed package(s): ${allowedPackagesStr}.`);
    }
    const isRestricted = !allowedPackagedSet.has(pkgName);
    if (isRestricted) {
      throw new _errors.FleetUnauthorizedError(`Authorization denied to package: ${pkgName}. Allowed package(s): ${allowedPackagesStr}`);
    }
    return false;
  });
}