"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSavedObjectsHandler = exports.fetchSavedObjectNamesHandler = exports.fetchIndexHandler = void 0;
var _debug = require("../../services/debug");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchIndexHandler = async (context, request, response) => {
  const coreContext = await context.core;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const res = await (0, _debug.fetchIndex)(esClient, request.body.index);
  return response.ok({
    body: res
  });
};
exports.fetchIndexHandler = fetchIndexHandler;
const fetchSavedObjectsHandler = async (context, request, response) => {
  const soClient = (await context.fleet).internalSoClient;
  const res = await (0, _debug.fetchSavedObjects)(soClient, request.body.type, request.body.name);
  return response.ok({
    body: res
  });
};
exports.fetchSavedObjectsHandler = fetchSavedObjectsHandler;
const fetchSavedObjectNamesHandler = async (context, request, response) => {
  const soClient = (await context.fleet).internalSoClient;
  const res = await (0, _debug.fetchSavedObjectNames)(soClient, request.body.type);
  return response.ok({
    body: res
  });
};
exports.fetchSavedObjectNamesHandler = fetchSavedObjectNamesHandler;