"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPanicLogsLastHour = getPanicLogsLastHour;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_LOGS_INDEX_PATTERN = 'logs-elastic_agent-*';
const MAX_MESSAGE_COUNT = 100;
const DEFAULT_LOGS_DATA = {
  agent_logs_panics_last_hour: []
};
async function getPanicLogsLastHour(esClient) {
  if (!esClient) {
    return DEFAULT_LOGS_DATA;
  }
  const res = await esClient.search({
    index: AGENT_LOGS_INDEX_PATTERN,
    size: MAX_MESSAGE_COUNT,
    sort: [{
      '@timestamp': 'desc'
    }],
    _source: ['message', '@timestamp'],
    query: {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: 'now-1h'
            }
          }
        }, {
          match: {
            message: 'panic'
          }
        }]
      }
    }
  });
  const panicLogsLastHour = res.hits.hits.map(hit => {
    var _hit$_source, _hit$_source2;
    return {
      message: ((_hit$_source = hit._source) === null || _hit$_source === void 0 ? void 0 : _hit$_source.message) || '',
      timestamp: ((_hit$_source2 = hit._source) === null || _hit$_source2 === void 0 ? void 0 : _hit$_source2['@timestamp']) || ''
    };
  });
  return {
    agent_logs_panics_last_hour: panicLogsLastHour
  };
}