"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageAgentPoliciesModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _agent_policy_multi_select = require("../applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/agent_policy_multi_select");
var _agent_policy_options = require("../applications/fleet/sections/agent_policy/create_package_policy_page/components/steps/components/agent_policy_options");
var _hooks = require("../applications/fleet/sections/agent_policy/edit_package_policy_page/hooks");
var _hooks2 = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/manage_agent_policies_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiConfirmModal = (0, _styledComponents.default)(_eui.EuiConfirmModal)`
  min-width: 448px;
`;
const ManageAgentPoliciesModal = ({
  onClose,
  selectedAgentPolicies,
  packagePolicyId,
  onAgentPoliciesChange
}) => {
  const initialPolicyIds = selectedAgentPolicies.map(policy => policy.id);
  const [selectedPolicyIds, setSelectedPolicyIds] = (0, _react.useState)(initialPolicyIds);
  const [isSubmitting, setIsSubmitting] = (0, _react.useState)(false);
  const {
    notifications
  } = (0, _hooks2.useStartServices)();
  const {
    packageInfo,
    packagePolicy,
    savePackagePolicy
  } = (0, _hooks.usePackagePolicyWithRelatedData)(packagePolicyId, {});
  const removedPolicies = (0, _react.useMemo)(() => selectedAgentPolicies.filter(policy => !selectedPolicyIds.find(id => policy.id === id)).map(policy => policy.name), [selectedAgentPolicies, selectedPolicyIds]);
  const onCancel = () => {
    onClose();
  };
  const onConfirm = async () => {
    setIsSubmitting(true);
    const {
      error
    } = await savePackagePolicy({
      policy_ids: selectedPolicyIds,
      ...(selectedPolicyIds.length === 0 ? {
        policy_id: undefined
      } : {})
    });
    setIsSubmitting(false);
    if (!error) {
      onAgentPoliciesChange();
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.manageAgentPolicies.updatedNotificationTitle', {
          defaultMessage: `Successfully updated ''{packagePolicyName}''`,
          values: {
            packagePolicyName: packagePolicy.name
          }
        }),
        'data-test-subj': 'policyUpdateSuccessToast'
      });
    } else {
      if (error.statusCode === 409) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.manageAgentPolicies.failedNotificationTitle', {
            defaultMessage: `Error updating ''{packagePolicyName}''`,
            values: {
              packagePolicyName: packagePolicy.name
            }
          }),
          toastMessage: _i18n.i18n.translate('xpack.fleet.manageAgentPolicies.failedConflictNotificationMessage', {
            defaultMessage: `Data is out of date. Refresh the page to get the latest policy.`
          })
        });
      } else {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.manageAgentPolicies.failedNotificationTitle', {
            defaultMessage: `Error updating ''{packagePolicyName}''`,
            values: {
              packagePolicyName: packagePolicy.name
            }
          })
        });
      }
    }
    onClose();
  };
  const {
    agentPolicyMultiOptions,
    isLoading
  } = (0, _agent_policy_options.useAgentPoliciesOptions)(packageInfo);
  return /*#__PURE__*/_react.default.createElement(StyledEuiConfirmModal, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAgentPolicies.confirmModalTitle",
      defaultMessage: "Manage agent policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAgentPolicies.confirmModalCancelButtonLabel",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAgentPolicies.confirmModalConfirmButtonLabel",
      defaultMessage: "Confirm",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }),
    buttonColor: "primary",
    confirmButtonDisabled: isSubmitting || (0, _lodash.isEqual)(initialPolicyIds, selectedPolicyIds),
    "data-test-subj": "manageAgentPoliciesModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.manageAgentPolicies.confirmModalDescription",
    defaultMessage: "Agent policies sharing this integration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "integrationNameText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.manageAgentPolicies.integrationName",
    defaultMessage: "Integration: ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  })), packagePolicy.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAgentPolicies.agentPoliciesLabel",
      defaultMessage: "Agent policies",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_policy_multi_select.AgentPolicyMultiSelect, {
    isLoading: isLoading,
    selectedPolicyIds: selectedPolicyIds,
    setSelectedPolicyIds: setSelectedPolicyIds,
    agentPolicyMultiOptions: agentPolicyMultiOptions,
    selectedAgentPolicies: selectedAgentPolicies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }))), removedPolicies.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    "data-test-subj": "confirmRemovePoliciesCallout",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAgentPolicies.calloutTitle",
      defaultMessage: "This action will update this integration",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.manageAgentPolicies.calloutBody",
    defaultMessage: "{removedPolicies} will no longer use this integration.",
    values: {
      removedPolicies: /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 46
        }
      }, removedPolicies.join(', '))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.manageAgentPolicies.confirmText",
    defaultMessage: "Are you sure you wish to continue?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  })))));
};
exports.ManageAgentPoliciesModal = ManageAgentPoliciesModal;