"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBrowseIntegrationHook = useBrowseIntegrationHook;
var _react = require("react");
var _hooks = require("../../../../../hooks");
var _use_available_packages = require("../../home/hooks/use_available_packages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBrowseIntegrationHook({
  prereleaseIntegrationsEnabled
}) {
  const {
    initialSelectedCategory,
    selectedCategory,
    setCategory,
    allCategories,
    mainCategories,
    onlyAgentlessFilter,
    isLoading,
    isLoadingCategories,
    isLoadingAllPackages,
    isLoadingAppendCustomIntegrations,
    eprPackageLoadingError,
    eprCategoryLoadingError,
    searchTerm,
    setSearchTerm: setSearchTermState,
    setUrlandPushHistory,
    setUrlandReplaceHistory,
    filteredCards: originalFilteredCards,
    availableSubCategories,
    selectedSubCategory,
    setSelectedSubCategory
  } = (0, _use_available_packages.useAvailablePackages)({
    prereleaseIntegrationsEnabled
  });
  const localSearch = (0, _hooks.useLocalSearch)(originalFilteredCards, !!isLoading);
  const filteredCards = (0, _react.useMemo)(() => {
    var _map, _localSearch$search;
    const searchResults = searchTerm ? (_map = localSearch === null || localSearch === void 0 ? void 0 : (_localSearch$search = localSearch.search(searchTerm)) === null || _localSearch$search === void 0 ? void 0 : _localSearch$search.map(match => match[_hooks.searchIdField])) !== null && _map !== void 0 ? _map : [] : [];
    return searchTerm ? originalFilteredCards.filter(item => {
      var _searchResults$includ;
      return (_searchResults$includ = searchResults.includes(item[_hooks.searchIdField])) !== null && _searchResults$includ !== void 0 ? _searchResults$includ : [];
    }) : originalFilteredCards;
  }, [localSearch, searchTerm, originalFilteredCards]);
  const onCategoryChange = (0, _react.useCallback)(({
    id
  }) => {
    setCategory(id);
    setSearchTermState('');
    setSelectedSubCategory(undefined);
    setUrlandPushHistory({
      searchString: '',
      categoryId: id,
      subCategoryId: '',
      onlyAgentless: onlyAgentlessFilter
    });
  }, [setCategory, setSearchTermState, setSelectedSubCategory, setUrlandPushHistory, onlyAgentlessFilter]);
  const setSearchTerm = (0, _react.useCallback)(term => {
    setSearchTermState(term);
    setUrlandReplaceHistory({
      searchString: term,
      categoryId: selectedCategory,
      subCategoryId: selectedSubCategory || ''
    });
  }, [setSearchTermState, selectedCategory, selectedSubCategory, setUrlandReplaceHistory]);
  return {
    initialSelectedCategory,
    selectedCategory,
    setCategory,
    allCategories,
    mainCategories,
    onlyAgentlessFilter,
    isLoading,
    isLoadingCategories,
    isLoadingAllPackages,
    isLoadingAppendCustomIntegrations,
    eprPackageLoadingError,
    eprCategoryLoadingError,
    searchTerm,
    setSearchTerm,
    setUrlandPushHistory,
    setUrlandReplaceHistory,
    filteredCards,
    availableSubCategories,
    selectedSubCategory,
    setSelectedSubCategory,
    onCategoryChange
  };
}