"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALL_INSTALLED_CATEGORY = exports.ALL_CATEGORY = void 0;
exports.CategoryFacets = CategoryFacets;
exports.UPDATE_FAILED_CATEGORY = exports.UPDATE_FAILED = exports.UPDATES_AVAILABLE_CATEGORY = exports.UPDATES_AVAILABLE = exports.Sidebar = exports.INSTALL_FAILED_CATEGORY = exports.INSTALL_FAILED = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _components = require("../../../../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/browse_integrations/components/side_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UPDATES_AVAILABLE = exports.UPDATES_AVAILABLE = 'updates_available';
const INSTALL_FAILED = exports.INSTALL_FAILED = 'install_failed';
const UPDATE_FAILED = exports.UPDATE_FAILED = 'update_failed';
const ALL_CATEGORY = exports.ALL_CATEGORY = {
  id: '',
  title: _i18n.i18n.translate('xpack.fleet.epmList.allPackagesFilterLinkText', {
    defaultMessage: 'All categories'
  })
};
const ALL_INSTALLED_CATEGORY = exports.ALL_INSTALLED_CATEGORY = {
  id: '',
  title: _i18n.i18n.translate('xpack.fleet.epmList.allPackagesInstalledFilterLinkText', {
    defaultMessage: 'All installed'
  })
};
const UPDATES_AVAILABLE_CATEGORY = exports.UPDATES_AVAILABLE_CATEGORY = {
  id: UPDATES_AVAILABLE,
  title: _i18n.i18n.translate('xpack.fleet.epmList.updatesAvailableFilterLinkText', {
    defaultMessage: 'Updates available'
  })
};
const INSTALL_FAILED_CATEGORY = exports.INSTALL_FAILED_CATEGORY = {
  id: INSTALL_FAILED,
  title: _i18n.i18n.translate('xpack.fleet.epmList.installFailedFilterLinkText', {
    defaultMessage: 'Install failed'
  })
};
const UPDATE_FAILED_CATEGORY = exports.UPDATE_FAILED_CATEGORY = {
  id: UPDATE_FAILED,
  title: _i18n.i18n.translate('xpack.fleet.epmList.updateFailedFilterLinkText', {
    defaultMessage: 'Update failed'
  })
};
const StickySidebar = (0, _styled.default)(_eui.EuiFlexItem)`
  position: sticky;
  top: var(--kbn-application--sticky-headers-offset, var(--kbn-layout--header-height, '0px'));
  padding-top: ${props => props.theme.euiTheme.size.m};
  max-height: calc(100vh - var(--kbn-layout--header-height, '0px'));
  overflow: scroll;
  padding-right: ${props => props.theme.euiTheme.size.l};
`;
const Sidebar = ({
  isLoading,
  categories,
  selectedCategory,
  onCategoryChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(StickySidebar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "categoriesUserIntegrationsAccordion",
    buttonContent: _i18n.i18n.translate('xpack.fleet.epmList.userIntegrationAccordionLabel', {
      defaultMessage: 'Your created integrations'
    }),
    buttonProps: {
      style: {
        fontWeight: euiTheme.font.weight.bold
      }
    },
    initialIsOpen: true,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }), "TODO"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "categoriesDevelopedByElasticAccordion",
    buttonContent: _i18n.i18n.translate('xpack.fleet.epmList.filterByCategoryAccordionLabel', {
      defaultMessage: 'Developed by Elastic'
    }),
    buttonProps: {
      style: {
        fontWeight: euiTheme.font.weight.bold
      }
    },
    initialIsOpen: true,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(CategoryFacets, {
    isLoading: isLoading,
    categories: categories,
    selectedCategory: selectedCategory,
    onCategoryChange: onCategoryChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  })));
};
exports.Sidebar = Sidebar;
function CategoryFacets({
  isLoading,
  categories,
  selectedCategory,
  onCategoryChange
}) {
  const controls = /*#__PURE__*/_react.default.createElement(_eui.EuiFacetGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_components.Loading, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  })) : categories.map(category => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
      "data-test-subj": `epmList.categories.${category.id}`,
      isSelected: category.id === selectedCategory,
      key: category.id,
      id: category.id,
      style: {
        padding: 0
      },
      quantity: category.count,
      onClick: () => onCategoryChange(category),
      "aria-label": _i18n.i18n.translate('xpack.fleet.epmList.facetButton.ariaLabel', {
        defaultMessage: '{key}, {count} {count, plural, one { integration } other { integrations }}',
        values: {
          key: category.title,
          count: category.count
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }, category.title);
  }));
  return controls;
}