"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectNamesCombo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _hooks = require("../../../hooks");
var _services = require("../../../../../../common/services");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/saved_object_names_combo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchSavedObjectNames = async type => {
  var _response$data;
  const response = await (0, _hooks.sendRequest)({
    method: 'post',
    path: _services.debugRoutesService.getSavedObjectNamesPath(),
    body: {
      type
    },
    version: _constants.API_VERSIONS.internal.v1
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  return (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.aggregations.names.buckets;
};
const SavedObjectNamesCombo = ({
  name,
  setName,
  type,
  setNamesStatus
}) => {
  const {
    data: savedObjectNames,
    status
  } = (0, _reactQuery.useQuery)(['debug-saved-object-names', type], () => fetchSavedObjectNames(type), {
    refetchOnWindowFocus: false
  });
  (0, _react.useEffect)(() => {
    setNamesStatus(status);
  }, [status, setNamesStatus]);
  const comboBoxOptions = (savedObjectNames !== null && savedObjectNames !== void 0 ? savedObjectNames : []).map(obj => ({
    label: obj.key,
    value: obj.key
  }));
  const selectedOption = comboBoxOptions.find(option => option.value === name);
  const selectedOptions = selectedOption ? [selectedOption] : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    prepend: "Name",
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel', {
      defaultMessage: 'Select a Saved Object'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel', {
      defaultMessage: 'Select a Saved Object'
    }),
    fullWidth: true,
    options: comboBoxOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    isLoading: status === 'loading',
    onChange: newSelectedOptions => {
      if (!newSelectedOptions.length) {
        setName(undefined);
      } else {
        setName(newSelectedOptions[0].value);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  });
};
exports.SavedObjectNamesCombo = SavedObjectNamesCombo;