"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INITIAL_AGENT_FIELDS_TO_EXPORT = exports.AGENT_FIELDS_TO_EXPORT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_AGENT_FIELDS_TO_EXPORT = exports.INITIAL_AGENT_FIELDS_TO_EXPORT = [{
  field: 'agent.id',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.agentIdField', {
    defaultMessage: 'Agent ID'
  })
}, {
  field: 'status',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.statusField', {
    defaultMessage: 'Status'
  })
}, {
  field: 'local_metadata.host.hostname',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.hostnameField', {
    defaultMessage: 'Host Name'
  })
}, {
  field: 'policy_id',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.policyIdField', {
    defaultMessage: 'Policy ID'
  })
},
// policy name would need to be enriched
{
  field: 'last_checkin',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.lastCheckinField', {
    defaultMessage: 'Last Checkin Time'
  })
}, {
  field: 'local_metadata.elastic.agent.version',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.agentVersionField', {
    defaultMessage: 'Agent Version'
  })
}];
const AGENT_FIELDS_TO_EXPORT = exports.AGENT_FIELDS_TO_EXPORT = [{
  field: 'active',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.activeField', {
    defaultMessage: 'Active'
  })
}, {
  field: 'audit_unenrolled_reason',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.auditUnenrolledReasonField', {
    defaultMessage: 'Audit Unenrolled Reason'
  })
}, {
  field: 'audit_unenrolled_time',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.auditUnenrolledTimeField', {
    defaultMessage: 'Audit Unenrolled Time'
  })
}, {
  field: 'enrolled_at',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.enrolledAtField', {
    defaultMessage: 'Enrolled At'
  })
}, {
  field: 'last_checkin_message',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.lastCheckinMessageField', {
    defaultMessage: 'Last Checkin Message'
  })
}, {
  field: 'last_checkin_status',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.lastCheckinStatusField', {
    defaultMessage: 'Last Checkin Status'
  })
}, {
  field: 'last_updated',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.lastUpdatedField', {
    defaultMessage: 'Last Updated Time'
  })
}, {
  field: 'local_metadata.elastic.agent.build.original',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.agentBuildOriginalField', {
    defaultMessage: 'Agent Build Original'
  })
}, {
  field: 'local_metadata.elastic.agent.log_level',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.logLevelField', {
    defaultMessage: 'Agent Log Level'
  })
}, {
  field: 'local_metadata.elastic.agent.snapshot',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.agentSnapshotField', {
    defaultMessage: 'Agent Snapshot'
  })
}, {
  field: 'local_metadata.elastic.agent.unprivileged',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.agentUnprivilegedField', {
    defaultMessage: 'Agent Unprivileged'
  })
}, {
  field: 'local_metadata.elastic.agent.upgradeable',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.agentUpgradeableField', {
    defaultMessage: 'Agent Upgradeable'
  })
}, {
  field: 'local_metadata.host.architecture',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.hostArchitectureField', {
    defaultMessage: 'Host Architecture'
  })
}, {
  field: 'local_metadata.host.id',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.hostIdField', {
    defaultMessage: 'Host ID'
  })
}, {
  field: 'local_metadata.host.ip',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.hostIpField', {
    defaultMessage: 'Host IP'
  })
}, {
  field: 'local_metadata.host.mac',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.hostMacField', {
    defaultMessage: 'Host Mac'
  })
}, {
  field: 'local_metadata.host.name',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.hostNameField', {
    defaultMessage: 'Host Name'
  })
}, {
  field: 'local_metadata.os.family',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.osFamilyField', {
    defaultMessage: 'OS Family'
  })
}, {
  field: 'local_metadata.os.full',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.osFullField', {
    defaultMessage: 'OS Full'
  })
}, {
  field: 'local_metadata.os.kernel',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.osKernelField', {
    defaultMessage: 'OS Kernel'
  })
}, {
  field: 'local_metadata.os.name',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.osNameField', {
    defaultMessage: 'OS Name'
  })
}, {
  field: 'local_metadata.os.platform',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.osPlatformField', {
    defaultMessage: 'OS Platform'
  })
}, {
  field: 'local_metadata.os.version',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.osVersionField', {
    defaultMessage: 'OS Version'
  })
}, {
  field: 'tags',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.tagsField', {
    defaultMessage: 'Tags'
  })
}, {
  field: 'unenrolled_at',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.unenrolledAtField', {
    defaultMessage: 'Unenrolled At'
  })
}, {
  field: 'unenrolled_reason',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.unenrolledReasonField', {
    defaultMessage: 'Unenrolled Reason'
  })
}, {
  field: 'unenrollment_started_at',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.unenrolledStartedAtField', {
    defaultMessage: 'Unenrolled Started At'
  })
}, {
  field: 'unhealthy_reason',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.unhealthyReasonField', {
    defaultMessage: 'Unhealthy Reason'
  })
}, {
  field: 'updated_at',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.updatedAtField', {
    defaultMessage: 'Updated At'
  })
}, {
  field: 'upgrade_started_at',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.upgradeStartedAtField', {
    defaultMessage: 'Upgrade Started At'
  })
}, {
  field: 'upgrade_status',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.upgradeStatusField', {
    defaultMessage: 'Upgrade Status'
  })
}, {
  field: 'upgraded_at',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.upgradedAtField', {
    defaultMessage: 'Upgraded At'
  })
}, {
  field: 'user_provided_metadata',
  description: _i18n.i18n.translate('xpack.fleet.exportCSV.userProvidedMetadataField', {
    defaultMessage: 'User Provided Metadata'
  })
}];