"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isAgentPrivilegeLevelChangeSupported = exports.isAgentEligibleForPrivilegeLevelChange = exports.MINIMUM_PRIVILEGE_LEVEL_CHANGE_AGENT_VERSION = void 0;
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _package_helpers = require("./package_helpers");
var _agent_policies_helpers = require("./agent_policies_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MINIMUM_PRIVILEGE_LEVEL_CHANGE_AGENT_VERSION = exports.MINIMUM_PRIVILEGE_LEVEL_CHANGE_AGENT_VERSION = '9.3.0';
const isAgentPrivilegeLevelChangeSupported = agent => {
  var _agent$agent;
  return !((_agent$agent = agent.agent) !== null && _agent$agent !== void 0 && _agent$agent.version) || (0, _gte.default)(agent.agent.version, MINIMUM_PRIVILEGE_LEVEL_CHANGE_AGENT_VERSION);
};
exports.isAgentPrivilegeLevelChangeSupported = isAgentPrivilegeLevelChangeSupported;
const isAgentEligibleForPrivilegeLevelChange = (agent, agentPolicy) => {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3;
  const hasFleetServer = agentPolicy && (0, _agent_policies_helpers.policyHasFleetServer)(agentPolicy);
  return isAgentPrivilegeLevelChangeSupported(agent) && ((_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.unprivileged) !== true && !(0, _package_helpers.isRootPrivilegeRequired)((agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.package_policies) || []) && !hasFleetServer;
};
exports.isAgentEligibleForPrivilegeLevelChange = isAgentEligibleForPrivilegeLevelChange;