"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitoringTypes = exports.installationStatuses = exports.displayedAssetTypesLookup = exports.displayedAssetTypes = exports.dataTypes = exports.autoUpgradePoliciesPackages = exports.autoUpdatePackages = exports.agentAssetTypes = exports.USER_SETTINGS_TEMPLATE_SUFFIX = exports.PACKAGE_TEMPLATE_SUFFIX = exports.PACKAGES_SAVED_OBJECT_TYPE = exports.OTEL_TEMPLATE_SUFFIX = exports.OTEL_COLLECTOR_INPUT_TYPE = exports.MAX_TIME_COMPLETE_INSTALL = exports.MAX_REINSTALL_RETRIES = exports.HIDDEN_API_REFERENCE_PACKAGES = exports.GLOBAL_DATA_TAG_EXCLUDED_INPUTS = exports.GENERIC_DATASET_NAME = exports.FLEET_UNIVERSAL_PROFILING_SYMBOLIZER_PACKAGE = exports.FLEET_UNIVERSAL_PROFILING_COLLECTOR_PACKAGE = exports.FLEET_SYSTEM_PACKAGE = exports.FLEET_SYNTHETICS_PACKAGE = exports.FLEET_SERVER_PACKAGE = exports.FLEET_KUBERNETES_PACKAGE = exports.FLEET_ENDPOINT_PACKAGE = exports.FLEET_ELASTIC_AGENT_PACKAGE = exports.FLEET_CONNECTORS_PACKAGE = exports.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE = exports.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_POSTURE_CNVM_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_POSTURE_ASSET_INVENTORY_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_ASSET_PACKAGE = exports.FLEET_CLOUD_DEFEND_PACKAGE = exports.FLEET_CLOUD_BEAT_PACKAGE = exports.FLEET_APM_PACKAGE = exports.DATA_STREAM_TYPE_VAR_NAME = exports.DATASET_VAR_NAME = exports.CUSTOM_INTEGRATION_PACKAGE_SPEC_VERSION = exports.ASSETS_SAVED_OBJECT_TYPE = void 0;
var _models = require("../types/models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PACKAGES_SAVED_OBJECT_TYPE = exports.PACKAGES_SAVED_OBJECT_TYPE = 'epm-packages';
const ASSETS_SAVED_OBJECT_TYPE = exports.ASSETS_SAVED_OBJECT_TYPE = 'epm-packages-assets';
const MAX_TIME_COMPLETE_INSTALL = exports.MAX_TIME_COMPLETE_INSTALL = 30 * 60 * 1000; // 30 minutes
const MAX_REINSTALL_RETRIES = exports.MAX_REINSTALL_RETRIES = 3;
const FLEET_SYSTEM_PACKAGE = exports.FLEET_SYSTEM_PACKAGE = 'system';
const FLEET_ELASTIC_AGENT_PACKAGE = exports.FLEET_ELASTIC_AGENT_PACKAGE = 'elastic_agent';
const FLEET_SERVER_PACKAGE = exports.FLEET_SERVER_PACKAGE = 'fleet_server';
const FLEET_ENDPOINT_PACKAGE = exports.FLEET_ENDPOINT_PACKAGE = 'endpoint';
const FLEET_APM_PACKAGE = exports.FLEET_APM_PACKAGE = 'apm';
const FLEET_SYNTHETICS_PACKAGE = exports.FLEET_SYNTHETICS_PACKAGE = 'synthetics';
const FLEET_KUBERNETES_PACKAGE = exports.FLEET_KUBERNETES_PACKAGE = 'kubernetes';
const FLEET_UNIVERSAL_PROFILING_SYMBOLIZER_PACKAGE = exports.FLEET_UNIVERSAL_PROFILING_SYMBOLIZER_PACKAGE = 'profiler_symbolizer';
const FLEET_UNIVERSAL_PROFILING_COLLECTOR_PACKAGE = exports.FLEET_UNIVERSAL_PROFILING_COLLECTOR_PACKAGE = 'profiler_collector';
const FLEET_CLOUD_SECURITY_POSTURE_PACKAGE = exports.FLEET_CLOUD_SECURITY_POSTURE_PACKAGE = 'cloud_security_posture';
const FLEET_CLOUD_SECURITY_ASSET_PACKAGE = exports.FLEET_CLOUD_SECURITY_ASSET_PACKAGE = 'cloud_asset_inventory';
const FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_POSTURE_KSPM_POLICY_TEMPLATE = 'kspm';
const FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_POSTURE_CSPM_POLICY_TEMPLATE = 'cspm';
const FLEET_CLOUD_SECURITY_POSTURE_ASSET_INVENTORY_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_POSTURE_ASSET_INVENTORY_POLICY_TEMPLATE = 'asset_inventory';
const FLEET_CLOUD_SECURITY_POSTURE_CNVM_POLICY_TEMPLATE = exports.FLEET_CLOUD_SECURITY_POSTURE_CNVM_POLICY_TEMPLATE = 'vuln_mgmt';
const FLEET_CLOUD_DEFEND_PACKAGE = exports.FLEET_CLOUD_DEFEND_PACKAGE = 'cloud_defend';
const FLEET_CLOUD_BEAT_PACKAGE = exports.FLEET_CLOUD_BEAT_PACKAGE = 'cloudbeat';
const FLEET_CONNECTORS_PACKAGE = exports.FLEET_CONNECTORS_PACKAGE = 'elastic_connectors';
const GLOBAL_DATA_TAG_EXCLUDED_INPUTS = exports.GLOBAL_DATA_TAG_EXCLUDED_INPUTS = new Set([FLEET_APM_PACKAGE, `pf-host-agent`, `pf-elastic-symbolizer`, `pf-elastic-collector`, `fleet-server`, FLEET_CLOUD_DEFEND_PACKAGE, `${FLEET_CLOUD_DEFEND_PACKAGE}/control`, FLEET_CLOUD_BEAT_PACKAGE, `${FLEET_CLOUD_BEAT_PACKAGE}/cis_k8s`, `${FLEET_CLOUD_BEAT_PACKAGE}/cis_eks`, `${FLEET_CLOUD_BEAT_PACKAGE}/cis_aws`, `${FLEET_CLOUD_BEAT_PACKAGE}/cis_gcp`, `${FLEET_CLOUD_BEAT_PACKAGE}/cis_azure`, `${FLEET_CLOUD_BEAT_PACKAGE}/vuln_mgmt_aws`]);
const PACKAGE_TEMPLATE_SUFFIX = exports.PACKAGE_TEMPLATE_SUFFIX = '@package';
const USER_SETTINGS_TEMPLATE_SUFFIX = exports.USER_SETTINGS_TEMPLATE_SUFFIX = '@custom';
const OTEL_TEMPLATE_SUFFIX = exports.OTEL_TEMPLATE_SUFFIX = 'otel';
const DATASET_VAR_NAME = exports.DATASET_VAR_NAME = 'data_stream.dataset';
const DATA_STREAM_TYPE_VAR_NAME = exports.DATA_STREAM_TYPE_VAR_NAME = 'data_stream.type';
const CUSTOM_INTEGRATION_PACKAGE_SPEC_VERSION = exports.CUSTOM_INTEGRATION_PACKAGE_SPEC_VERSION = '2.9.0';
const GENERIC_DATASET_NAME = exports.GENERIC_DATASET_NAME = 'generic';

/*
 Package rules:
|               | autoUpdatePackages |
|---------------|:------------------:|
| Auto-updates  |          ✔️         |


We also define "auto upgrade policies" packages below. These are packages that are considered "stack-aligned"
and require policies to be auto-upgraded in order to properly function. Commonly, packages that ship custom policy
editor UI's in the Kibana codebase will be included in this set of packages to avoid backwards-compatibility concerns
in their custom policy editor implementations.

*/

const autoUpdatePackages = exports.autoUpdatePackages = [FLEET_ENDPOINT_PACKAGE, FLEET_APM_PACKAGE, FLEET_SYNTHETICS_PACKAGE, FLEET_CLOUD_SECURITY_POSTURE_PACKAGE, FLEET_CLOUD_SECURITY_ASSET_PACKAGE];
const HIDDEN_API_REFERENCE_PACKAGES = exports.HIDDEN_API_REFERENCE_PACKAGES = [FLEET_ENDPOINT_PACKAGE, FLEET_APM_PACKAGE, FLEET_SYNTHETICS_PACKAGE];
const autoUpgradePoliciesPackages = exports.autoUpgradePoliciesPackages = [FLEET_APM_PACKAGE, FLEET_SYNTHETICS_PACKAGE, FLEET_CLOUD_SECURITY_POSTURE_PACKAGE, FLEET_CLOUD_SECURITY_ASSET_PACKAGE];
const agentAssetTypes = exports.agentAssetTypes = {
  Input: 'input'
};
const dataTypes = exports.dataTypes = {
  Logs: 'logs',
  Metrics: 'metrics',
  Traces: 'traces'
};

// currently identical but may be a subset or otherwise different some day
const monitoringTypes = exports.monitoringTypes = Object.values(dataTypes);
const installationStatuses = exports.installationStatuses = {
  Installed: 'installed',
  Installing: 'installing',
  InstallFailed: 'install_failed',
  NotInstalled: 'not_installed'
};

// These asset types are allowed to be shown on Integration details > Assets tab
// This array also controls the order in which the asset types are displayed
const displayedAssetTypes = exports.displayedAssetTypes = [...Object.values(_models.KibanaSavedObjectType), ...Object.values(_models.ElasticsearchAssetType).filter(assetType => assetType !== _models.ElasticsearchAssetType.knowledgeBase) // Filter out knowledgeBase assets, we dont want to expose to the user
];
const displayedAssetTypesLookup = exports.displayedAssetTypesLookup = new Set(displayedAssetTypes);
const OTEL_COLLECTOR_INPUT_TYPE = exports.OTEL_COLLECTOR_INPUT_TYPE = 'otelcol';