"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetSourcesRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _esqlTypes = require("@kbn/esql-types");
var _esql_service = require("../services/esql_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerGetSourcesRoute = (router, {
  logger
}) => {
  router.get({
    path: `${_esqlTypes.SOURCES_AUTOCOMPLETE_ROUTE}{scope}`,
    validate: {
      params: _configSchema.schema.object({
        scope: _configSchema.schema.oneOf([_configSchema.schema.literal('all'), _configSchema.schema.literal('local')], {
          defaultValue: 'local' // Default to 'local' if no scope is provided
        })
      })
    },
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    }
  }, async (requestHandlerContext, request, response) => {
    try {
      const {
        scope
      } = request.params;
      const core = await requestHandlerContext.core;
      const service = new _esql_service.EsqlService({
        client: core.elasticsearch.client.asCurrentUser
      });
      const result = await service.getAllIndices(scope);
      return response.ok({
        body: result
      });
    } catch (error) {
      logger.get().debug(error);
      throw error;
    }
  });
};
exports.registerGetSourcesRoute = registerGetSourcesRoute;