"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PromQLBuilder = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint-disable @typescript-eslint/no-namespace */
let PromQLBuilder = exports.PromQLBuilder = void 0;
(function (_PromQLBuilder) {
  const parserFields = _PromQLBuilder.parserFields = ({
    location = {
      min: 0,
      max: 0
    },
    text = '',
    incomplete = false
  } = {}) => ({
    location,
    text,
    incomplete
  });
  let expression;
  (function (_expression) {
    const query = _expression.query = (expr, fromParser) => {
      return {
        dialect: 'promql',
        type: 'query',
        name: '',
        expression: expr,
        ...PromQLBuilder.parserFields(fromParser)
      };
    };
    const parens = _expression.parens = (child, fromParser) => {
      return {
        dialect: 'promql',
        type: 'parens',
        name: '',
        child,
        ...PromQLBuilder.parserFields(fromParser)
      };
    };
    let func;
    (function (_func) {
      const call = _func.call = (name, args, grouping, groupingPosition, fromParser) => {
        return {
          dialect: 'promql',
          type: 'function',
          name,
          args,
          grouping,
          groupingPosition,
          ...PromQLBuilder.parserFields(fromParser)
        };
      };
    })(func || (func = _expression.func || (_expression.func = {})));
    let selector;
    (function (_selector) {
      const node = _selector.node = (template, fromParser) => {
        var _template$metric$name, _template$metric;
        const metricName = (_template$metric$name = (_template$metric = template.metric) === null || _template$metric === void 0 ? void 0 : _template$metric.name) !== null && _template$metric$name !== void 0 ? _template$metric$name : '';

        // Build args array with all defined children in order
        const args = [];
        if (template.metric) {
          args.push(template.metric);
        }
        if (template.labelMap) {
          args.push(template.labelMap);
        }
        if (template.duration) {
          args.push(template.duration);
        }
        if (template.evaluation) {
          args.push(template.evaluation);
        }
        return {
          dialect: 'promql',
          type: 'selector',
          name: metricName,
          args,
          metric: template.metric,
          labelMap: template.labelMap,
          duration: template.duration,
          evaluation: template.evaluation,
          ...PromQLBuilder.parserFields(fromParser)
        };
      };
    })(selector || (selector = _expression.selector || (_expression.selector = {})));
    const binary = _expression.binary = (operator, left, right, options, fromParser) => {
      return {
        dialect: 'promql',
        type: 'binary-expression',
        name: operator,
        left,
        right,
        bool: options === null || options === void 0 ? void 0 : options.bool,
        modifier: options === null || options === void 0 ? void 0 : options.modifier,
        ...PromQLBuilder.parserFields(fromParser)
      };
    };
    const unary = _expression.unary = (operator, arg, fromParser) => {
      return {
        dialect: 'promql',
        type: 'unary-expression',
        name: operator,
        arg,
        ...PromQLBuilder.parserFields(fromParser)
      };
    };
    const subquery = _expression.subquery = (expr, range, resolution, evaluation, fromParser) => {
      return {
        dialect: 'promql',
        type: 'subquery',
        name: 'subquery',
        expr,
        range,
        resolution,
        evaluation,
        ...PromQLBuilder.parserFields(fromParser)
      };
    };
    let literal;
    (function (_literal) {
      const integer = _literal.integer = (value, fromParser) => {
        return {
          dialect: 'promql',
          type: 'literal',
          literalType: 'integer',
          name: String(value),
          value,
          ...PromQLBuilder.parserFields(fromParser)
        };
      };
      const decimal = _literal.decimal = (value, fromParser) => {
        return {
          dialect: 'promql',
          type: 'literal',
          literalType: 'decimal',
          name: String(value),
          value,
          ...PromQLBuilder.parserFields(fromParser)
        };
      };
      const hexadecimal = _literal.hexadecimal = (value, text, fromParser) => {
        return {
          dialect: 'promql',
          type: 'literal',
          literalType: 'hexadecimal',
          name: text,
          value,
          ...PromQLBuilder.parserFields(fromParser)
        };
      };
      const string = _literal.string = (value, valueUnquoted, fromParser) => {
        return {
          dialect: 'promql',
          type: 'literal',
          literalType: 'string',
          name: value,
          value,
          valueUnquoted,
          ...PromQLBuilder.parserFields(fromParser)
        };
      };
      const time = _literal.time = (value, fromParser) => {
        return {
          dialect: 'promql',
          type: 'literal',
          literalType: 'time',
          name: value,
          value,
          ...PromQLBuilder.parserFields(fromParser)
        };
      };
    })(literal || (literal = _expression.literal || (_expression.literal = {})));
  })(expression || (expression = _PromQLBuilder.expression || (_PromQLBuilder.expression = {})));
  const identifier = _PromQLBuilder.identifier = (name, fromParser) => {
    return {
      dialect: 'promql',
      type: 'identifier',
      name,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const labelMap = _PromQLBuilder.labelMap = (labels, fromParser) => {
    return {
      dialect: 'promql',
      type: 'label-map',
      name: '',
      args: labels,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const label = _PromQLBuilder.label = (labelName, operator, value, fromParser) => {
    return {
      dialect: 'promql',
      type: 'label',
      name: labelName.name,
      labelName,
      operator,
      value,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const grouping = _PromQLBuilder.grouping = (kind, labels, fromParser) => {
    return {
      dialect: 'promql',
      type: 'grouping',
      name: kind,
      args: labels,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const modifier = _PromQLBuilder.modifier = (kind, labels, groupModifier, fromParser) => {
    return {
      dialect: 'promql',
      type: 'modifier',
      name: kind,
      labels,
      groupModifier,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const groupModifier = _PromQLBuilder.groupModifier = (kind, labels, fromParser) => {
    return {
      dialect: 'promql',
      type: 'group-modifier',
      name: kind,
      labels,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const evaluation = _PromQLBuilder.evaluation = (offset, at, fromParser) => {
    return {
      dialect: 'promql',
      type: 'evaluation',
      name: 'evaluation',
      offset,
      at,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const offset = _PromQLBuilder.offset = (duration, negative = false, fromParser) => {
    return {
      dialect: 'promql',
      type: 'offset',
      name: 'offset',
      negative,
      duration,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const at = _PromQLBuilder.at = (value, negative = false, fromParser) => {
    return {
      dialect: 'promql',
      type: 'at',
      name: 'at',
      negative,
      value,
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
  const unknown = _PromQLBuilder.unknown = fromParser => {
    return {
      dialect: 'promql',
      type: 'unknown',
      name: 'unknown',
      ...PromQLBuilder.parserFields(fromParser)
    };
  };
})(PromQLBuilder || (exports.PromQLBuilder = PromQLBuilder = {}));