"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _antlr = require("antlr4");
if (!_antlr.Lexer) {
  throw new Error('Failed to import Lexer from antlr4');
}
class lexer_config extends _antlr.Lexer {
  constructor(...args) {
    super(...args);
    this._promqlDepth = 0;
  }
  isDevVersion() {
    return true;
  }
  hasMetricsCommand() {
    return true;
  }

  // PromQL parenthesis depth tracking for nested parentheses in PromQL queries
  incPromqlDepth() {
    this._promqlDepth++;
  }
  decPromqlDepth() {
    this._promqlDepth--;
  }
  resetPromqlDepth() {
    this._promqlDepth = 0;
  }
  getPromqlDepth() {
    return this._promqlDepth;
  }

  // Returns true if we're inside a nested PromQL query (depth > 1)
  isPromqlQuery() {
    return this._promqlDepth > 1;
  }
}
exports.default = lexer_config;
module.exports = exports.default;