"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _is = require("../../../ast/is");
var _metadata = require("../options/metadata");
var _utils = require("../../definitions/utils");
var _sources = require("../../definitions/utils/validation/sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validate = (command, ast, context) => {
  var _metadataStatement$ar;
  const metadataStatement = command.args.find(arg => (0, _is.isOptionNode)(arg) && arg.name === 'metadata');
  const messages = [];
  const fields = (_metadataStatement$ar = metadataStatement === null || metadataStatement === void 0 ? void 0 : metadataStatement.args.filter(_is.isColumn)) !== null && _metadataStatement$ar !== void 0 ? _metadataStatement$ar : [];
  for (const field of fields) {
    if (!_metadata.METADATA_FIELDS.includes(field.name)) {
      messages.push((0, _utils.getMessageFromId)({
        messageId: 'unknownMetadataField',
        values: {
          value: field.name,
          availableFields: Array.from(_metadata.METADATA_FIELDS).join(', ')
        },
        locations: field.location
      }));
    }
  }
  const sources = command.args.filter(arg => (0, _is.isSource)(arg));
  messages.push(...(0, _sources.validateSources)(sources, context));
  return messages;
};
exports.validate = validate;