"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnsAfter = void 0;
var _is = require("../../../ast/is");
var _utils = require("../../definitions/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const columnsAfter = (command, _previousColumns, query) => {
  const typeOf = thing => (0, _utils.getExpressionType)(thing, new Map());
  const columns = [];
  for (const expression of command.args) {
    if ((0, _is.isAssignment)(expression) && (0, _is.isColumn)(expression.args[0])) {
      const name = expression.args[0].parts.join('.');
      const newColumn = {
        name,
        type: typeOf(expression.args[1]),
        location: expression.args[0].location,
        userDefined: true
      };
      columns.push(newColumn);
    } else if (!Array.isArray(expression)) {
      const newColumn = {
        name: query.substring(expression.location.min, expression.location.max + 1),
        type: typeOf(expression),
        location: expression.location,
        userDefined: true
      };
      columns.push(newColumn);
    }
  }
  return columns;
};
exports.columnsAfter = columnsAfter;