"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlCommandRegistry = void 0;
var _registry = require("./registry");
var _limit = require("./limit");
var _drop = require("./drop");
var _keep = require("./keep");
var _fork = require("./fork");
var _rename = require("./rename");
var _change_point = require("./change_point");
var _completion = require("./completion");
var _dissect = require("./dissect");
var _enrich = require("./enrich");
var _eval = require("./eval");
var _from = require("./from");
var _grok = require("./grok");
var _join = require("./join");
var _mv_expand = require("./mv_expand");
var _row = require("./row");
var _sort = require("./sort");
var _stats = require("./stats");
var _inlinestats = require("./inlinestats");
var _sample = require("./sample");
var _show = require("./show");
var _timeseries = require("./timeseries");
var _where = require("./where");
var _fuse = require("./fuse");
var _rerank = require("./rerank");
var _elastisearch_command_data_loader = require("./elastisearch_command_data_loader");
var _set = require("./set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const esqlCommandRegistry = exports.esqlCommandRegistry = new _registry.CommandRegistry();
const baseCommands = [_limit.limitCommand, _drop.dropCommand, _fork.forkCommand, _rename.renameCommand, _change_point.changePointCommand, _completion.completionCommand, _dissect.dissectCommand, _enrich.enrichCommand, _eval.evalCommand, _from.fromCommand, _grok.grokCommand, _join.joinCommand, _mv_expand.mvExpandCommand, _keep.keepCommand, _row.rowCommand, _sort.sortCommand, _stats.statsCommand, _inlinestats.inlineStatsCommand, _sample.sampleCommand, _set.setCommand, _show.showCommand, _timeseries.timeseriesCommand, _where.whereCommand, _fuse.fuseCommand, _rerank.rerankCommand];
baseCommands.forEach(command => {
  const mergedCommand = (0, _elastisearch_command_data_loader.mergeCommandWithGeneratedCommandData)(command);
  esqlCommandRegistry.registerCommand(mergedCommand);
});