"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FUSE_OPTIONS = void 0;
exports.buildMissingMetadataMessage = buildMissingMetadataMessage;
exports.extractFuseArgs = extractFuseArgs;
exports.findCommandOptionByName = findCommandOptionByName;
exports.immediatelyAfterOptionField = immediatelyAfterOptionField;
exports.immediatelyAfterOptionFieldsList = immediatelyAfterOptionFieldsList;
var _i18n = require("@kbn/i18n");
var _ = require("../../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FUSE_OPTIONS = exports.FUSE_OPTIONS = ['score by', 'key by', 'group by', 'with'];
function extractFuseArgs(command) {
  const fuseType = command.fuseType;
  const scoreBy = findCommandOptionByName(command, 'score by');
  const keyBy = findCommandOptionByName(command, 'key by');
  const groupBy = findCommandOptionByName(command, 'group by');
  const withOption = findCommandOptionByName(command, 'with');
  return {
    fuseType,
    scoreBy,
    keyBy,
    groupBy,
    withOption
  };
}
function findCommandOptionByName(command, name) {
  return command.args.find(arg => (0, _.isOptionNode)(arg) && arg.name.toLowerCase() === name.toLowerCase());
}

/**
 * Checks if we are immediately after a field that belongs to an option.
 * This is useful for being able to decide we are still in the SCORE BY position.
 *
 * Example: "SCORE BY field_name/"  returns true
 *          "SCORE BY field_name /" returns false
 */
function immediatelyAfterOptionField(innerText, optionName) {
  const regex = new RegExp(`${optionName}\\s+\\S+$`, 'i');
  return regex.test(innerText);
}

/**
 * Checks if we are immediately after a field in a list of fields that belongs to an option
 * Example: "KEY BY field1, field2/"  returns true
 *          "KEY BY field1, field2 /" returns false
 */
function immediatelyAfterOptionFieldsList(innerText, optionName) {
  const regex = new RegExp(`${optionName}(\\s+\\S+,?)+$`, 'i');
  return regex.test(innerText);
}
function buildMissingMetadataMessage(command, metadataField) {
  return {
    location: command.location,
    text: _i18n.i18n.translate('kbn-esql-ast.esql.validation.fuseMissingMetadata', {
      defaultMessage: `[FUSE] The FROM command is missing the {metadataField} METADATA field.`,
      values: {
        metadataField
      }
    }),
    type: 'error',
    code: `fuseMissingMetadata`
  };
}