"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columnsAfter = void 0;
var _lodash = require("lodash");
var _ = require("..");
var _is = require("../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const columnsAfter = async (command, _previousColumns, query, additionalFields) => {
  const options = command.args.filter(arg => !Array.isArray(arg) && arg.type === 'option');
  const sources = command.args.filter(arg => !Array.isArray(arg) && arg.type === 'source');
  const subqueries = command.args.filter(_is.isSubQuery);
  const promises = [...sources.map(source => additionalFields.fromFrom({
    ...command,
    args: [source, ...options]
  })), ...subqueries.map(subquery => processSubquery(subquery.child, query, additionalFields))];
  const results = await Promise.all(promises);
  const allColumns = results.flat();
  return (0, _lodash.uniqBy)(allColumns, 'name');
};
exports.columnsAfter = columnsAfter;
async function processSubquery(subquery, query, additionalFields) {
  let columns = [];

  // Execute each command in subquery pipeline: FROM index | KEEP
  for (const subCommand of subquery.commands) {
    var _commandDef$methods;
    const commandDef = _.esqlCommandRegistry.getCommandByName(subCommand.name);
    if (commandDef !== null && commandDef !== void 0 && (_commandDef$methods = commandDef.methods) !== null && _commandDef$methods !== void 0 && _commandDef$methods.columnsAfter) {
      columns = await commandDef.methods.columnsAfter(subCommand, columns, query, additionalFields);
    }
  }
  return columns;
}