"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.changePointCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _columns_after = require("./columns_after");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const changePointCommandMethods = {
  validate: _validate.validate,
  autocomplete: _autocomplete.autocomplete,
  columnsAfter: _columns_after.columnsAfter
};
const changePointCommand = exports.changePointCommand = {
  name: 'change_point',
  methods: changePointCommandMethods,
  metadata: {
    preview: true,
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.changePointDoc', {
      defaultMessage: 'Detect change point in the query results'
    }),
    declaration: `CHANGE_POINT <value> ON <field_name> AS <type>, <pvalue>`,
    examples: ['… | CHANGE_POINT value', '… | CHANGE_POINT value ON timestamp', '… | CHANGE_POINT value ON timestamp AS type, pvalue']
  }
};