"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnValidator = void 0;
exports.validateColumnForCommand = validateColumnForCommand;
var _errors = require("../errors");
var _columns = require("../columns");
var _is = require("../../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function validateColumnForCommand(column, commandName, context) {
  return new ColumnValidator(column, context, commandName).validate();
}
class ColumnValidator {
  constructor(column, context, commandName) {
    this.column = column;
    this.context = context;
    this.commandName = commandName;
  }
  validate() {
    if (!this.exists) {
      return [_errors.errors.unknownColumn(this.column)];
    }
    return [];
  }
  get exists() {
    if (!(0, _is.isParametrized)(this.column) && !(0, _columns.getColumnExists)(this.column, this.context, this.commandName === 'row')) {
      return false;
    }
    return true;
  }
}
exports.ColumnValidator = ColumnValidator;