"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestAfterNot = suggestAfterNot;
var _is = require("../../../../../../ast/is");
var _operators = require("../../../operators");
var _suggestion_builder = require("../suggestion_builder");
var _all_operators = require("../../../../all_operators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Suggests completions after the NOT keyword
 * - After unary NOT function: NOT / (suggest boolean functions/fields)
 * - After NOT keyword before operators: field NOT / (suggest IN, LIKE, RLIKE)
 */
async function suggestAfterNot(ctx) {
  const {
    expressionRoot
  } = ctx;

  // Case 1: Unary NOT operator - suggest boolean expressions
  if (expressionRoot && (0, _is.isFunctionExpression)(expressionRoot) && expressionRoot.name === 'not') {
    const builder = new _suggestion_builder.SuggestionBuilder(ctx);
    await builder.addFields({
      types: ['boolean'],
      addSpaceAfterField: true,
      promoteToTop: false
    });
    builder.addFunctions({
      types: ['boolean']
    });
    return builder.build();
  }

  // Case 2: NOT as part of binary operator - suggest IN, LIKE, RLIKE
  return _all_operators.operatorsDefinitions.filter(({
    name
  }) => name === 'like' || name === 'rlike' || name === 'in').map(_operators.getOperatorSuggestion);
}