"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settings = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Do not edit this manually... generated by scripts/generate_settings.ts
const projectRouting = {
  name: 'project_routing',
  type: 'keyword',
  serverlessOnly: true,
  preview: true,
  snapshotOnly: true,
  description: 'A project routing expression, used to define which projects to route the query to. Only supported if Cross-Project Search is enabled.',
  ignoreAsSuggestion: false
};
const timeZone = {
  name: 'time_zone',
  type: 'keyword',
  serverlessOnly: false,
  preview: true,
  snapshotOnly: true,
  description: 'The default timezone to be used in the query, by the functions and commands that require it. Defaults to UTC',
  ignoreAsSuggestion: true
};
const settings = exports.settings = [projectRouting, timeZone];