"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupingFunctionDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../../registry/types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * __AUTOGENERATED FILE. DO NOT EDIT THIS FILE DIRECTLY.__
 *
 * @note This file is generated by the `generate_function_definitions.ts`
 * script. Do not edit it manually.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const bucketDefinition = {
  type: _types2.FunctionDefinitionTypes.GROUPING,
  name: 'bucket',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.bucket', {
    defaultMessage: 'Creates groups of values - buckets - out of a datetime or numeric input.\nThe size of the buckets can either be provided directly, or chosen based on a recommended count and values range.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'date_period',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'time_duration',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'date_period',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'date',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'keyword',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'date',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'keyword',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'text',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'text',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'date_nanos',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'time_duration',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'double',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'double',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'long',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'double',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'integer',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'long',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'double',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'double',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'integer',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'double',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'integer',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'integer',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }, {
      name: 'from',
      type: 'long',
      optional: false,
      description: 'Start of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }, {
      name: 'to',
      type: 'long',
      optional: false,
      description: 'End of the range. Can be a number, a date or a date expressed as a string.',
      constantOnly: true
    }],
    returnType: 'double'
  }, {
    params: [{
      name: 'field',
      type: 'long',
      optional: false,
      description: 'Numeric or date expression from which to derive buckets.'
    }, {
      name: 'buckets',
      type: 'long',
      optional: false,
      description: 'Target number of buckets, or desired bucket size if `from` and `to` parameters are omitted.',
      constantOnly: true
    }],
    returnType: 'double'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.STATS_BY],
  examples: ['FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hire_date = MV_SORT(VALUES(hire_date)) BY month = BUCKET(hire_date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hires_per_month = COUNT(*) BY month = BUCKET(hire_date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")\n| SORT month', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hires_per_week = COUNT(*) BY week = BUCKET(hire_date, 100, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS hires_per_week = COUNT(*) BY week = BUCKET(hire_date, 1 week)\n| SORT week', 'FROM employees\n| STATS COUNT(*) by bs = BUCKET(salary, 20, 25324, 74999)\n| SORT bs', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS c = COUNT(1) BY b = BUCKET(salary, 5000.)\n| SORT b', 'FROM sample_data\n| WHERE @timestamp >= NOW() - 1 day and @timestamp < NOW()\n| STATS COUNT(*) BY bucket = BUCKET(@timestamp, 25, NOW() - 1 day, NOW())', 'FROM employees\n| WHERE hire_date >= "1985-01-01T00:00:00Z" AND hire_date < "1986-01-01T00:00:00Z"\n| STATS AVG(salary) BY bucket = BUCKET(hire_date, 20, "1985-01-01T00:00:00Z", "1986-01-01T00:00:00Z")', 'FROM employees\n| STATS s1 = b1 + 1, s2 = BUCKET(salary / 1000 + 999, 50.) + 2 BY b1 = BUCKET(salary / 100 + 99, 50.), b2 = BUCKET(salary / 1000 + 999, 50.)\n| SORT b1, b2\n| KEEP s1, b1, s2, b2', 'FROM employees\n| STATS dates = MV_SORT(VALUES(birth_date)) BY b = BUCKET(birth_date + 1 HOUR, 1 YEAR) - 1 HOUR\n| EVAL d_count = MV_COUNT(dates)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const categorizeDefinition = {
  type: _types2.FunctionDefinitionTypes.GROUPING,
  name: 'categorize',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.categorize', {
    defaultMessage: 'Groups text messages into categories of similarly formatted text values.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'field',
      type: 'keyword',
      optional: false,
      description: 'Expression to categorize'
    }],
    license: 'platinum',
    returnType: 'keyword'
  }, {
    params: [{
      name: 'field',
      type: 'text',
      optional: false,
      description: 'Expression to categorize'
    }],
    license: 'platinum',
    returnType: 'keyword'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.STATS_BY],
  license: 'platinum',
  observabilityTier: 'COMPLETE',
  examples: ['FROM sample_data\n| STATS count=COUNT() BY category=CATEGORIZE(message)']
};

// Do not edit this manually... generated by scripts/generate_function_definitions.ts
const tbucketDefinition = {
  type: _types2.FunctionDefinitionTypes.GROUPING,
  name: 'tbucket',
  description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.tbucket', {
    defaultMessage: 'Creates groups of values - buckets - out of a @timestamp attribute. The size of the buckets must be provided directly.'
  }),
  preview: false,
  alias: undefined,
  signatures: [{
    params: [{
      name: 'buckets',
      type: 'date_period',
      optional: false,
      description: 'Desired bucket size.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'buckets',
      type: 'date_period',
      optional: false,
      description: 'Desired bucket size.'
    }],
    returnType: 'date_nanos'
  }, {
    params: [{
      name: 'buckets',
      type: 'time_duration',
      optional: false,
      description: 'Desired bucket size.'
    }],
    returnType: 'date'
  }, {
    params: [{
      name: 'buckets',
      type: 'time_duration',
      optional: false,
      description: 'Desired bucket size.'
    }],
    returnType: 'date_nanos'
  }],
  locationsAvailable: [_types.Location.STATS, _types.Location.STATS_BY],
  examples: ['FROM sample_data\n| STATS min = MIN(@timestamp), max = MAX(@timestamp) BY bucket = TBUCKET(1 hour)\n| SORT min', 'FROM sample_data\n| STATS min = MIN(@timestamp), max = MAX(@timestamp) BY bucket = TBUCKET("1 hour")\n| SORT min']
};
const groupingFunctionDefinitions = exports.groupingFunctionDefinitions = [bucketDefinition, categorizeDefinition, tbucketDefinition];