"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Builder = void 0;
var _is = require("../is");
var _parser = require("../../parser");
var _pretty_print = require("../../pretty_print");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint-disable @typescript-eslint/no-namespace */
let Builder = exports.Builder = void 0;
(function (_Builder) {
  const parserFields = _Builder.parserFields = ({
    location = {
      min: 0,
      max: 0
    },
    text = '',
    incomplete = false
  } = {}) => ({
    location,
    text,
    incomplete
  });
  const command = _Builder.command = (template, fromParser) => {
    var _template$args;
    return {
      ...template,
      ...Builder.parserFields(fromParser),
      args: (_template$args = template.args) !== null && _template$args !== void 0 ? _template$args : [],
      type: 'command'
    };
  };
  const option = _Builder.option = (template, fromParser) => {
    var _template$args2;
    return {
      ...template,
      ...Builder.parserFields(fromParser),
      args: (_template$args2 = template.args) !== null && _template$args2 !== void 0 ? _template$args2 : [],
      type: 'option'
    };
  };
  const comment = _Builder.comment = (subtype, text, location) => {
    return {
      type: 'comment',
      subtype,
      text,
      location
    };
  };
  let expression;
  (function (_expression) {
    const query = _expression.query = (commands = [], fromParser, header) => {
      return {
        ...Builder.parserFields(fromParser),
        header,
        commands,
        type: 'query',
        name: ''
      };
    };
    let source;
    (function (_source) {
      const node = _source.node = (indexOrTemplate, fromParser) => {
        var _template$name;
        const template = typeof indexOrTemplate === 'string' || (0, _is.isStringLiteral)(indexOrTemplate) ? {
          sourceType: 'index',
          index: indexOrTemplate
        } : indexOrTemplate;
        const prefix = !template.prefix ? undefined : typeof template.prefix === 'string' ? Builder.expression.literal.string(template.prefix, {
          unquoted: true
        }) : template.prefix;
        const index = !template.index ? undefined : typeof template.index === 'string' ? Builder.expression.literal.string(template.index, {
          unquoted: true
        }) : template.index;
        const selector = !template.selector ? undefined : typeof template.selector === 'string' ? Builder.expression.literal.string(template.selector, {
          unquoted: true
        }) : template.selector;
        const sourceNode = {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'source',
          prefix,
          index,
          selector,
          name: (_template$name = template.name) !== null && _template$name !== void 0 ? _template$name : ''
        };
        if (!sourceNode.name) {
          sourceNode.name = _pretty_print.LeafPrinter.source(sourceNode);
        }
        return sourceNode;
      };
      const index = _source.index = (indexName, prefix, selector, template, fromParser) => {
        return Builder.expression.source.node({
          ...template,
          index: indexName,
          prefix,
          selector,
          sourceType: 'index'
        }, fromParser);
      };
    })(source || (source = _expression.source || (_expression.source = {})));
    const parens = _expression.parens = (child, fromParser) => {
      return {
        type: 'parens',
        name: '',
        child,
        ...Builder.parserFields(fromParser)
      };
    };
    const column = _expression.column = (nameOrTemplate, qualifier, fromParser) => {
      if (typeof nameOrTemplate === 'string') {
        nameOrTemplate = [nameOrTemplate];
      }
      const template = Array.isArray(nameOrTemplate) ? {
        args: nameOrTemplate.map(name => name[0] === '?' ? Builder.param.build(name) : Builder.identifier(name))
      } : nameOrTemplate;
      if (qualifier) {
        var _template$args3;
        const qualifierNode = typeof qualifier === 'string' ? Builder.identifier(qualifier) : qualifier;
        template.qualifier = qualifierNode;
        template.args = [qualifierNode, ...((_template$args3 = template.args) !== null && _template$args3 !== void 0 ? _template$args3 : [])];
      }
      const node = {
        ...template,
        ...Builder.parserFields(fromParser),
        parts: template.args.map(arg => arg.type === 'identifier' ? arg.name : _pretty_print.LeafPrinter.param(arg)),
        quoted: false,
        name: '',
        type: 'column'
      };
      node.name = _pretty_print.LeafPrinter.column(node);
      return node;
    };
    const order = _expression.order = (operand, template, fromParser) => {
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        name: '',
        args: [operand],
        type: 'order'
      };
    };
    const inlineCast = _expression.inlineCast = (template, fromParser) => {
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        type: 'inlineCast',
        name: ''
      };
    };
    let func;
    (function (_func) {
      const node = _func.node = (template, fromParser) => {
        return {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'function'
        };
      };
      const call = _func.call = (nameOrOperator, args, template, fromParser) => {
        let name;
        let operator;
        if (typeof nameOrOperator === 'string') {
          name = nameOrOperator;
          operator = Builder.identifier({
            name
          });
        } else {
          operator = nameOrOperator;
          name = _pretty_print.LeafPrinter.print(operator);
        }
        return Builder.expression.func.node({
          ...template,
          name,
          operator,
          args,
          subtype: 'variadic-call'
        }, fromParser);
      };
      const unary = _func.unary = (name, arg, template, fromParser) => {
        const operator = Builder.identifier({
          name
        });
        return Builder.expression.func.node({
          ...template,
          name,
          operator,
          args: [arg],
          subtype: 'unary-expression'
        }, fromParser);
      };
      const postfix = _func.postfix = (name, arg, template, fromParser) => {
        const operator = Builder.identifier({
          name
        });
        return Builder.expression.func.node({
          ...template,
          name,
          operator,
          args: [arg],
          subtype: 'postfix-unary-expression'
        }, fromParser);
      };
      const binary = _func.binary = (name, args, template, fromParser) => {
        var _template$operator;
        const operator = (_template$operator = template === null || template === void 0 ? void 0 : template.operator) !== null && _template$operator !== void 0 ? _template$operator : Builder.identifier({
          name
        });
        return Builder.expression.func.node({
          ...template,
          name,
          operator,
          args,
          subtype: 'binary-expression'
        }, fromParser);
      };
    })(func || (func = _expression.func || (_expression.func = {})));
    const where = _expression.where = (args, template, fromParser) => Builder.expression.func.binary('where', args, template, fromParser);
    let list;
    (function (_list) {
      const literal = _list.literal = (template = {}, fromParser) => {
        return {
          values: [],
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'list',
          name: ''
        };
      };
      const tuple = _list.tuple = (template = {}, fromParser) => {
        return {
          values: [],
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'list',
          subtype: 'tuple',
          name: ''
        };
      };
    })(list || (list = _expression.list || (_expression.list = {})));
    let literal;
    (function (_literal) {
      const nil = _literal.nil = (template, fromParser) => {
        const node = {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'literal',
          literalType: 'null',
          name: 'NULL',
          value: 'NULL'
        };
        return node;
      };
      const boolean = _literal.boolean = (value, template, fromParser) => {
        const node = {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'literal',
          literalType: 'boolean',
          name: String(value),
          value: String(value)
        };
        return node;
      };
      const numeric = _literal.numeric = (template, fromParser) => {
        const node = {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'literal',
          name: template.value.toString()
        };
        return node;
      };
      const integer = _literal.integer = (value, template, fromParser) => {
        return Builder.expression.literal.numeric({
          ...template,
          value,
          literalType: 'integer'
        }, fromParser);
      };
      const decimal = _literal.decimal = (value, template, fromParser) => {
        return Builder.expression.literal.numeric({
          ...template,
          value,
          literalType: 'double'
        }, fromParser);
      };
      const timespan = _literal.timespan = (quantity, unit, fromParser) => {
        return {
          ...Builder.parserFields(fromParser),
          type: 'literal',
          literalType: _parser.TIME_DURATION_UNITS.has(unit.toLowerCase()) ? 'time_duration' : 'date_period',
          unit,
          quantity,
          value: `${quantity} ${unit}`,
          name: `${quantity} ${unit}`
        };
      };
      const string = _literal.string = (valueUnquoted, template, fromParser) => {
        var _template$name2;
        const value = !!(template !== null && template !== void 0 && template.unquoted) ? valueUnquoted : '"' + valueUnquoted.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/\t/g, '\\t') + '"';
        const name = (_template$name2 = template === null || template === void 0 ? void 0 : template.name) !== null && _template$name2 !== void 0 ? _template$name2 : value;
        const node = {
          ...template,
          ...Builder.parserFields(fromParser),
          type: 'literal',
          literalType: 'keyword',
          name,
          value,
          valueUnquoted
        };
        return node;
      };
    })(literal || (literal = _expression.literal || (_expression.literal = {})));
    const map = _expression.map = (template = {}, fromParser) => {
      var _template$entries;
      const entries = (_template$entries = template.entries) !== null && _template$entries !== void 0 ? _template$entries : [];
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        name: '',
        type: 'map',
        entries
      };
    };
    const entry = _expression.entry = (key, value, fromParser, template) => {
      if (typeof key === 'string') {
        key = Builder.expression.literal.string(key);
      }
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        name: '',
        type: 'map-entry',
        key,
        value
      };
    };
  })(expression || (expression = _Builder.expression || (_Builder.expression = {})));
  const identifier = _Builder.identifier = (nameOrTemplate, fromParser) => {
    const template = typeof nameOrTemplate === 'string' ? {
      name: nameOrTemplate
    } : nameOrTemplate;
    return {
      ...template,
      ...Builder.parserFields(fromParser),
      type: 'identifier'
    };
  };
  let param;
  (function (_param) {
    const unnamed = _param.unnamed = (fromParser, template) => {
      const node = {
        ...Builder.parserFields(fromParser),
        paramKind: '?',
        ...template,
        name: '',
        value: '',
        paramType: 'unnamed',
        type: 'literal',
        literalType: 'param'
      };
      return node;
    };
    const named = _param.named = (template, fromParser) => {
      const node = {
        paramKind: '?',
        ...template,
        ...Builder.parserFields(fromParser),
        name: '',
        type: 'literal',
        literalType: 'param',
        paramType: 'named'
      };
      return node;
    };
    const positional = _param.positional = (template, fromParser) => {
      const node = {
        paramKind: '?',
        ...template,
        ...Builder.parserFields(fromParser),
        name: '',
        type: 'literal',
        literalType: 'param',
        paramType: 'positional'
      };
      return node;
    };
    const build = _param.build = (name, options = {}, fromParser) => {
      var _options$paramKind;
      let paramKind = (_options$paramKind = options.paramKind) !== null && _options$paramKind !== void 0 ? _options$paramKind : '?';
      if (name.startsWith('??')) {
        paramKind = '??';
      } else if (name.startsWith('?')) {
        paramKind = '?';
      }
      const value = name.startsWith('?') ? name.slice(paramKind === '?' ? 1 : 2) : name;
      if (!value) {
        return Builder.param.unnamed(options, {
          paramKind
        });
      }
      const isNumeric = !isNaN(Number(value)) && String(Number(value)) === value;
      if (isNumeric) {
        return Builder.param.positional({
          ...options,
          paramKind,
          value: Number(value)
        }, fromParser);
      } else {
        return Builder.param.named({
          ...options,
          paramKind,
          value
        }, fromParser);
      }
    };
  })(param || (param = _Builder.param || (_Builder.param = {})));
  let header;
  (function (_header) {
    // eslint-disable-next-line @typescript-eslint/no-shadow
    const command = _header.command = Object.assign((template, fromParser) => {
      var _template$args4;
      return {
        ...template,
        ...Builder.parserFields(fromParser),
        args: (_template$args4 = template.args) !== null && _template$args4 !== void 0 ? _template$args4 : [],
        type: 'header-command'
      };
    }, {
      set: (args, template, fromParser) => {
        return Builder.header.command({
          args,
          ...template,
          name: 'set'
        }, fromParser);
      }
    });
  })(header || (header = _Builder.header || (_Builder.header = {})));
})(Builder || (exports.Builder = Builder = {}));