"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEmptyFilter = void 0;
var _esQueryConstants = require("@kbn/es-query-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildEmptyFilter = (isPinned, index) => {
  const meta = {
    disabled: false,
    negate: false,
    alias: null,
    index
  };
  const $state = {
    store: isPinned ? _esQueryConstants.FilterStateStore.GLOBAL_STATE : _esQueryConstants.FilterStateStore.APP_STATE
  };
  return {
    meta,
    $state
  };
};
exports.buildEmptyFilter = buildEmptyFilter;