"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.storedFilterSchema = exports.storedFilterMetaSchema = exports.filterStateStoreSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQueryConstants = require("@kbn/es-query-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const filterStateStoreSchema = exports.filterStateStoreSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_esQueryConstants.FilterStateStore.APP_STATE), _configSchema.schema.literal(_esQueryConstants.FilterStateStore.GLOBAL_STATE)], {
  meta: {
    description: "Denote whether a filter is specific to an application's context (e.g. 'appState') or whether it should be applied globally (e.g. 'globalState')."
  }
});
const storedFilterMetaSchema = exports.storedFilterMetaSchema = _configSchema.schema.object({
  alias: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
  disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  negate: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  controlledBy: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Identifies the owner the filter.'
    }
  })),
  group: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The group to which this filter belongs.'
    }
  })),
  relation: _configSchema.schema.maybe(_configSchema.schema.string()),
  // field is missing from the Filter type, but is stored in SerializedSearchSourceFields
  // see the todo in src/platform/packages/shared/kbn-es-query/src/filters/helpers/update_filter.ts
  field: _configSchema.schema.maybe(_configSchema.schema.string()),
  index: _configSchema.schema.maybe(_configSchema.schema.string()),
  isMultiIndex: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  key: _configSchema.schema.maybe(_configSchema.schema.string()),
  // We could consider creating FilterMetaParams as a schema to match the concrete Filter type.
  // However, this is difficult because FilterMetaParams can be a `storedFilterSchema` which is defined below.
  // This would require a more complex schema definition that can handle recursive types.
  // For now, we use `schema.any()` to allow flexibility in the params field.
  params: _configSchema.schema.maybe(_configSchema.schema.any()),
  value: _configSchema.schema.maybe(_configSchema.schema.string())
}, {
  unknowns: 'allow'
});
const storedFilterSchema = exports.storedFilterSchema = _configSchema.schema.object({
  meta: storedFilterMetaSchema,
  query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
  $state: _configSchema.schema.maybe(_configSchema.schema.object({
    store: filterStateStoreSchema
  }))
}, {
  meta: {
    id: 'kbn-es-query-server-storedFilterSchema'
  }
});