"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.disableManagedEntityDiscovery = disableManagedEntityDiscovery;
exports.uninstallBuiltInEntityDefinitions = uninstallBuiltInEntityDefinitions;
exports.uninstallEntityDefinition = uninstallEntityDefinition;
var _delete_entity_definition = require("./delete_entity_definition");
var _delete_ingest_pipeline = require("./delete_ingest_pipeline");
var _manage_index_templates = require("../manage_index_templates");
var _stop_transforms = require("./stop_transforms");
var _delete_transforms = require("./delete_transforms");
var _entity_client = require("../entity_client");
var _auth = require("../auth");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function uninstallEntityDefinition({
  definition,
  esClient,
  soClient,
  logger
}) {
  await (0, _stop_transforms.stopTransforms)(esClient, definition, logger);
  await (0, _delete_transforms.deleteTransforms)(esClient, definition, logger);
  await (0, _delete_ingest_pipeline.deleteIngestPipelines)(esClient, definition, logger);
  await (0, _manage_index_templates.deleteTemplates)(esClient, definition, logger);
  await (0, _delete_entity_definition.deleteEntityDefinition)(soClient, definition);
}
async function uninstallBuiltInEntityDefinitions({
  entityClient,
  deleteData = false
}) {
  const {
    definitions
  } = await entityClient.getEntityDefinitions({
    builtIn: true,
    perPage: 1000
  });
  await Promise.allSettled(definitions.map(async ({
    id
  }) => {
    await entityClient.deleteEntityDefinition({
      id,
      deleteData
    });
  }));
  return definitions;
}
async function disableManagedEntityDiscovery({
  server,
  isServerless
}) {
  const apiKey = await (0, _auth.readEntityDiscoveryAPIKey)(server);
  if (!apiKey) {
    return;
  }
  const {
    clusterClient,
    soClient
  } = (0, _utils.getClientsFromAPIKey)({
    apiKey,
    server
  });
  const entityClient = new _entity_client.EntityClient({
    clusterClient,
    soClient,
    isServerless,
    logger: server.logger
  });
  await uninstallBuiltInEntityDefinitions({
    entityClient,
    deleteData: true
  });
  await (0, _auth.deleteEntityDiscoveryAPIKey)(soClient);
  await server.security.authc.apiKeys.invalidateAsInternalUser({
    ids: [apiKey.id]
  });
}