"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanScript = cleanScript;
exports.initializePathScript = initializePathScript;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initializePathScript(field) {
  const fieldParts = field.split('.');
  if (fieldParts.length === 1) {
    return '';
  }
  return fieldParts.reduce((acc, _part, currentIndex, parts) => {
    if (currentIndex + 1 === parts.length) {
      return acc;
    }
    const currentSegment = parts.slice(0, currentIndex + 1).join('.');
    const next = `
        if (ctx.${currentSegment} == null) {
            ctx.${currentSegment} = new HashMap();
        }
      `;
    return `${acc}\n${next}`;
  }, '');
}
function cleanScript(script) {
  const codeLines = script.split('\n').map(line => line.trim()).filter(line => line !== '');
  let cleanedScript = '';
  let indentLevel = 0;
  for (let i = 0; i < codeLines.length; i++) {
    if (i === 0) {
      cleanedScript += `${codeLines[i]}\n`;
      continue;
    }
    const previousLine = i === 0 ? null : codeLines[i - 1];
    const currentLine = codeLines[i];
    if ((0, _lodash.last)(previousLine) === '{') {
      indentLevel++;
    } else if ((0, _lodash.first)(currentLine) === '}') {
      indentLevel--;
    }
    const indent = new Array(indentLevel).fill('  ').join('');
    cleanedScript += `${indent}${currentLine}\n`;
  }
  return cleanedScript.trim();
}