"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointsHeaderAction = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _connection_details = require("@kbn/cloud/connection_details");
var _i18n = require("@kbn/i18n");
var _endpoint_icon = require("./endpoint_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/shared/layout/endpoints_header_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EndpointsHeaderAction = ({
  children
}) => {
  const [open, setOpen] = _react.default.useState(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }, !!children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 26
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: _endpoint_icon.EndpointIcon,
    size: "s",
    onClick: () => setOpen(x => !x),
    "data-test-subj": "enterpriseSearchEndpointsHeaderActionEndpointsApiKeysButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.pageTemplate.endpointsButtonLabel', {
    defaultMessage: 'Endpoints & API keys'
  })))), open && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setOpen(false),
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_connection_details.KibanaWiredConnectionDetailsProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_connection_details.ConnectionDetailsFlyoutContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }))));
};
exports.EndpointsHeaderAction = EndpointsHeaderAction;