"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateSideNavItems = void 0;
var _nav_link_helpers = require("./nav_link_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSideNavItems = (navItems, deepLinks, subItemsMap = {}) => {
  const sideNavItems = [];
  for (const navItem of navItems) {
    let sideNavChildItems;
    const {
      deepLink,
      items,
      ...rest
    } = navItem;
    const subItems = subItemsMap === null || subItemsMap === void 0 ? void 0 : subItemsMap[navItem.id];
    if (items || subItems) {
      sideNavChildItems = [];
      if (items) {
        sideNavChildItems.push(...generateSideNavItems(items, deepLinks, subItemsMap));
      }
      if (subItems) {
        sideNavChildItems.push(...subItems);
      }
    }
    let sideNavItem;
    if (deepLink) {
      const navLinkParams = getNavLinkParameters(deepLink, deepLinks);
      if (navLinkParams !== undefined) {
        var _navItem$name;
        const name = (_navItem$name = navItem.name) !== null && _navItem$name !== void 0 ? _navItem$name : getDeepLinkTitle(deepLink.link, deepLinks);
        sideNavItem = {
          ...rest,
          name,
          ...(0, _nav_link_helpers.generateNavLink)({
            ...navLinkParams,
            items: sideNavChildItems
          })
        };
      }
    } else {
      sideNavItem = {
        ...rest,
        items: sideNavChildItems,
        name: navItem.name
      };
    }
    if (isValidSideNavItem(sideNavItem)) {
      sideNavItems.push(sideNavItem);
    }
  }
  return sideNavItems;
};
exports.generateSideNavItems = generateSideNavItems;
const getNavLinkParameters = (navLink, deepLinks) => {
  const {
    link,
    ...navLinkProps
  } = navLink;
  const deepLink = deepLinks[link];
  if (!deepLink || !deepLink.url) return undefined;
  return {
    ...navLinkProps,
    shouldNotCreateHref: true,
    shouldNotPrepend: true,
    to: deepLink.url
  };
};
const getDeepLinkTitle = (link, deepLinks) => {
  const deepLink = deepLinks[link];
  if (!deepLink || !deepLink.url) return undefined;
  return deepLink.title;
};
function isValidSideNavItem(item) {
  var _item$items$length, _item$items;
  if (item === undefined) return false;
  if (item.href || item.onClick) return true;
  if ((_item$items$length = item === null || item === void 0 ? void 0 : (_item$items = item.items) === null || _item$items === void 0 ? void 0 : _item$items.length) !== null && _item$items$length !== void 0 ? _item$items$length : 0 > 0) return true;
  return false;
}