"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhaseTracker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class PhaseTracker {
  constructor() {
    (0, _defineProperty2.default)(this, "firstLoadCompleteTime", void 0);
    (0, _defineProperty2.default)(this, "embeddableStartTime", performance.now());
    (0, _defineProperty2.default)(this, "subscriptions", new _rxjs.Subscription());
    (0, _defineProperty2.default)(this, "phase$", new _rxjs.BehaviorSubject(undefined));
  }
  getPhase$() {
    return this.phase$;
  }
  trackPhaseEvents(uuid, api) {
    const dataLoading$ = (0, _presentationPublishing.apiPublishesDataLoading)(api) ? api.dataLoading$ : new _rxjs.BehaviorSubject(false);
    const rendered$ = (0, _presentationPublishing.apiPublishesRendered)(api) ? api.rendered$ : new _rxjs.BehaviorSubject(true);
    this.subscriptions.add((0, _rxjs.combineLatest)([dataLoading$, rendered$]).subscribe(([dataLoading, rendered]) => {
      if (!this.firstLoadCompleteTime) {
        this.firstLoadCompleteTime = performance.now();
      }
      const duration = this.firstLoadCompleteTime - this.embeddableStartTime;
      const status = dataLoading || !rendered ? 'loading' : 'rendered';
      this.phase$.next({
        id: uuid,
        status,
        timeToEvent: duration
      });
    }));
  }
  cleanup() {
    this.subscriptions.unsubscribe();
  }
}
exports.PhaseTracker = PhaseTracker;