"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCapabilitiesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _constants = require("../../../common/constants");
var _build_response = require("../../lib/build_response");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the assistant capabilities for the requesting plugin
 *
 * @param router IRouter for registering routes
 */
const getCapabilitiesRoute = router => {
  router.versioned.get({
    access: _elasticAssistantCommon.INTERNAL_API_ACCESS,
    path: _constants.CAPABILITIES,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      response: {
        200: {
          body: {
            custom: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.GetCapabilitiesResponse)
          }
        }
      }
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const assistantContext = await context.elasticAssistant;
    const logger = assistantContext.logger;
    try {
      const pluginName = (0, _helpers.getPluginNameFromRequest)({
        request,
        defaultPluginName: _helpers.DEFAULT_PLUGIN_NAME,
        logger
      });
      const registeredFeatures = assistantContext.getRegisteredFeatures(pluginName);
      return response.ok({
        body: registeredFeatures
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getCapabilitiesRoute = getCapabilitiesRoute;