"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.promptGroupId = exports.promptDictionary = exports.localPrompts = void 0;
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const promptGroupId = exports.promptGroupId = {
  attackDiscovery: 'attackDiscovery',
  aiAssistant: 'aiAssistant',
  defendInsights: {
    incompatibleAntivirus: 'defendInsights-incompatibleAntivirus',
    policyResponseFailure: 'defendInsights-policyResponseFailure'
  },
  // TODO remove after 1 week to ensure both versions are available while users upgrade
  aiForSoc: 'aiForSoc',
  aiForEntityAnalytics: 'aiForEntityDetails',
  ease: 'ease'
};
const promptDictionary = exports.promptDictionary = {
  alertSummary: `alertSummary`,
  alertSummarySystemPrompt: `alertSummarySystemPrompt`,
  entityDetailsHighlights: `entityDetailsHighlights`,
  costSavingsInsightPart1: `costSavingsInsightPart1`,
  costSavingsInsightPart2: `costSavingsInsightPart2`,
  systemPrompt: `systemPrompt`,
  userPrompt: `userPrompt`,
  chatTitle: `chatTitle`,
  attackDiscoveryDefault: `default`,
  attackDiscoveryRefine: `refine`,
  attackDiscoveryContinue: `continue`,
  attackDiscoveryDetailsMarkdown: `detailsMarkdown`,
  attackDiscoveryEntitySummaryMarkdown: `entitySummaryMarkdown`,
  attackDiscoveryMitreAttackTactics: `mitreAttackTactics`,
  attackDiscoverySummaryMarkdown: `summaryMarkdown`,
  attackDiscoveryGenerationTitle: `generationTitle`,
  attackDiscoveryGenerationInsights: `generationInsights`,
  defendInsightsIncompatibleAntivirusDefault: `defendInsights-incompatibleAntivirusDefault`,
  defendInsightsIncompatibleAntivirusRefine: `defendInsights-incompatibleAntivirusRefine`,
  defendInsightsIncompatibleAntivirusContinue: `defendInsights-incompatibleAntivirusContinue`,
  defendInsightsIncompatibleAntivirusGroup: 'defendInsights-incompatibleAntivirusGroup',
  defendInsightsIncompatibleAntivirusEvents: 'defendInsights-incompatibleAntivirusEvents',
  defendInsightsIncompatibleAntivirusEventsId: 'defendInsights-incompatibleAntivirusEventsId',
  defendInsightsIncompatibleAntivirusEventsEndpointId: 'defendInsights-incompatibleAntivirusEventsEndpointId',
  defendInsightsIncompatibleAntivirusEventsValue: 'defendInsights-incompatibleAntivirusEventsValue',
  defendInsightsPolicyResponseFailureDefault: `defendInsights-policyResponseFailureDefault`,
  defendInsightsPolicyResponseFailureRefine: `defendInsights-policyResponseFailureRefine`,
  defendInsightsPolicyResponseFailureContinue: `defendInsights-policyResponseFailureContinue`,
  defendInsightsPolicyResponseFailureGroup: 'defendInsights-policyResponseFailureGroup',
  defendInsightsPolicyResponseFailureEvents: 'defendInsights-policyResponseFailureEvents',
  defendInsightsPolicyResponseFailureEventsId: 'defendInsights-policyResponseFailureEventsId',
  defendInsightsPolicyResponseFailureEventsEndpointId: 'defendInsights-policyResponseFailureEventsEndpointId',
  defendInsightsPolicyResponseFailureEventsValue: 'defendInsights-policyResponseFailureEventsValue',
  defendInsightsPolicyResponseFailureRemediation: 'defendInsights-policyResponseFailureRemediation',
  defendInsightsPolicyResponseFailureRemediationMessage: 'defendInsights-policyResponseFailureRemediationMessage',
  defendInsightsPolicyResponseFailureRemediationLink: 'defendInsights-policyResponseFailureRemediationLink',
  // context prompts
  alertEvaluation: `alertEvaluation`,
  assetAnalysis: `assetAnalysis`,
  dataQualityAnalysis: 'dataQualityAnalysis',
  ruleAnalysis: 'ruleAnalysis',
  // starter prompts
  starterPromptDescription1: 'starterPromptDescription1',
  starterPromptTitle1: 'starterPromptTitle1',
  starterPromptIcon1: 'starterPromptIcon1',
  starterPromptPrompt1: 'starterPromptPrompt1',
  starterPromptDescription2: 'starterPromptDescription2',
  starterPromptTitle2: 'starterPromptTitle2',
  starterPromptIcon2: 'starterPromptIcon2',
  starterPromptPrompt2: 'starterPromptPrompt2',
  starterPromptDescription3: 'starterPromptDescription3',
  starterPromptTitle3: 'starterPromptTitle3',
  starterPromptIcon3: 'starterPromptIcon3',
  starterPromptPrompt3: 'starterPromptPrompt3',
  starterPromptDescription4: 'starterPromptDescription4',
  starterPromptTitle4: 'starterPromptTitle4',
  starterPromptIcon4: 'starterPromptIcon4',
  starterPromptPrompt4: 'starterPromptPrompt4'
};
const localPrompts = exports.localPrompts = [{
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'openai',
  prompt: {
    default: _prompts.DEFAULT_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.DEFAULT_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'bedrock',
  prompt: {
    default: _prompts.BEDROCK_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.systemPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'gemini',
  prompt: {
    default: _prompts.GEMINI_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.userPrompt,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'gemini',
  prompt: {
    default: _prompts.GEMINI_USER_PROMPT
  }
}, {
  promptId: promptDictionary.attackDiscoveryDefault,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_DEFAULT
  }
}, {
  promptId: promptDictionary.attackDiscoveryRefine,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_REFINE
  }
}, {
  promptId: promptDictionary.attackDiscoveryContinue,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_CONTINUE
  }
}, {
  promptId: promptDictionary.attackDiscoveryDetailsMarkdown,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_DETAILS_MARKDOWN
  }
}, {
  promptId: promptDictionary.attackDiscoveryEntitySummaryMarkdown,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_ENTITY_SUMMARY_MARKDOWN
  }
}, {
  promptId: promptDictionary.attackDiscoveryMitreAttackTactics,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_MITRE_ATTACK_TACTICS
  }
}, {
  promptId: promptDictionary.attackDiscoverySummaryMarkdown,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_SUMMARY_MARKDOWN
  }
}, {
  promptId: promptDictionary.attackDiscoveryGenerationTitle,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_TITLE
  }
}, {
  promptId: promptDictionary.attackDiscoveryGenerationInsights,
  promptGroupId: promptGroupId.attackDiscovery,
  prompt: {
    default: _prompts.ATTACK_DISCOVERY_GENERATION_INSIGHTS
  }
}, {
  promptId: promptDictionary.chatTitle,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.DEFAULT_CHAT_TITLE
  }
}, {
  promptId: promptDictionary.chatTitle,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'bedrock',
  prompt: {
    default: _prompts.BEDROCK_CHAT_TITLE
  }
}, {
  promptId: promptDictionary.chatTitle,
  promptGroupId: promptGroupId.aiAssistant,
  provider: 'gemini',
  prompt: {
    default: _prompts.GEMINI_CHAT_TITLE
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusDefault,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.DEFAULT
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusRefine,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.REFINE
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusContinue,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.CONTINUE
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusGroup,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.GROUP
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusEvents,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.EVENTS
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusEventsId,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.EVENTS_ID
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusEventsEndpointId,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.EVENTS_ENDPOINT_ID
  }
}, {
  promptId: promptDictionary.defendInsightsIncompatibleAntivirusEventsValue,
  promptGroupId: promptGroupId.defendInsights.incompatibleAntivirus,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.INCOMPATIBLE_ANTIVIRUS.EVENTS_VALUE
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureDefault,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.DEFAULT
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureRefine,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.REFINE
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureContinue,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.CONTINUE
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureGroup,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.GROUP
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureEvents,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.EVENTS
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureEventsId,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.EVENTS_ID
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureEventsEndpointId,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.EVENTS_ENDPOINT_ID
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureEventsValue,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.EVENTS_VALUE
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureRemediation,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.REMEDIATION
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureRemediationMessage,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.REMEDIATION_MESSAGE
  }
}, {
  promptId: promptDictionary.defendInsightsPolicyResponseFailureRemediationLink,
  promptGroupId: promptGroupId.defendInsights.policyResponseFailure,
  prompt: {
    default: _prompts.DEFEND_INSIGHTS.POLICY_RESPONSE_FAILURE.REMEDIATION_LINK
  }
}, {
  promptId: promptDictionary.alertSummary,
  promptGroupId: promptGroupId.aiForSoc,
  prompt: {
    default: _prompts.ALERT_SUMMARY_500
  }
}, {
  promptId: promptDictionary.alertSummarySystemPrompt,
  promptGroupId: promptGroupId.aiForSoc,
  prompt: {
    default: _prompts.ALERT_SUMMARY_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.costSavingsInsightPart1,
  promptGroupId: promptGroupId.aiForSoc,
  prompt: {
    default: _prompts.costSavingsInsightPart1
  }
}, {
  promptId: promptDictionary.costSavingsInsightPart2,
  promptGroupId: promptGroupId.aiForSoc,
  prompt: {
    default: _prompts.costSavingsInsightPart2
  }
}, {
  promptId: promptDictionary.entityDetailsHighlights,
  promptGroupId: promptGroupId.aiForEntityAnalytics,
  prompt: {
    default: _prompts.ENTITY_DETAILS_HIGHLIGHTS_PROMPT
  }
}, {
  promptId: promptDictionary.alertSummary,
  promptGroupId: promptGroupId.ease,
  prompt: {
    default: _prompts.ALERT_SUMMARY_500
  }
}, {
  promptId: promptDictionary.alertSummarySystemPrompt,
  promptGroupId: promptGroupId.ease,
  prompt: {
    default: _prompts.ALERT_SUMMARY_SYSTEM_PROMPT
  }
}, {
  promptId: promptDictionary.costSavingsInsightPart1,
  promptGroupId: promptGroupId.ease,
  prompt: {
    default: _prompts.costSavingsInsightPart1
  }
}, {
  promptId: promptDictionary.costSavingsInsightPart2,
  promptGroupId: promptGroupId.ease,
  prompt: {
    default: _prompts.costSavingsInsightPart2
  }
}, {
  promptId: promptDictionary.alertEvaluation,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.ALERT_EVALUATION
  }
}, {
  promptId: promptDictionary.assetAnalysis,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.ENTITY_ANALYSIS
  }
}, {
  promptId: promptDictionary.dataQualityAnalysis,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.DATA_QUALITY_ANALYSIS
  }
}, {
  promptId: promptDictionary.ruleAnalysis,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.RULE_ANALYSIS
  }
}, {
  promptId: promptDictionary.starterPromptDescription1,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptDescription1
  }
}, {
  promptId: promptDictionary.starterPromptTitle1,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptTitle1
  }
}, {
  promptId: promptDictionary.starterPromptIcon1,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptIcon1
  }
}, {
  promptId: promptDictionary.starterPromptPrompt1,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptPrompt1
  }
}, {
  promptId: promptDictionary.starterPromptDescription2,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptDescription2
  }
}, {
  promptId: promptDictionary.starterPromptTitle2,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptTitle2
  }
}, {
  promptId: promptDictionary.starterPromptIcon2,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptIcon2
  }
}, {
  promptId: promptDictionary.starterPromptPrompt2,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptPrompt2
  }
}, {
  promptId: promptDictionary.starterPromptDescription3,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptDescription3
  }
}, {
  promptId: promptDictionary.starterPromptTitle3,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptTitle3
  }
}, {
  promptId: promptDictionary.starterPromptIcon3,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptIcon3
  }
}, {
  promptId: promptDictionary.starterPromptPrompt3,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptPrompt3
  }
}, {
  promptId: promptDictionary.starterPromptDescription4,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptDescription4
  }
}, {
  promptId: promptDictionary.starterPromptTitle4,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptTitle4
  }
}, {
  promptId: promptDictionary.starterPromptIcon4,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptIcon4
  }
}, {
  promptId: promptDictionary.starterPromptPrompt4,
  promptGroupId: promptGroupId.aiAssistant,
  prompt: {
    default: _prompts.starterPromptPrompt4
  }
}];