"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERTS_INDEX_PATTERN = void 0;
exports.updateAlertsWithAttackIds = updateAlertsWithAttackIds;
var _fields = require("../fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_INDEX_PATTERN = exports.ALERTS_INDEX_PATTERN = '.alerts-security.alerts-';
async function updateAlertsWithAttackIds({
  esClient,
  alertIdToAttackIdsMap,
  spaceId
}) {
  if (!spaceId) {
    throw new Error('Param `spaceId` cannot be empty');
  }
  const alertIdsToUpdate = Array.from(Object.keys(alertIdToAttackIdsMap));
  if (!alertIdsToUpdate.length) {
    return;
  }
  await esClient.updateByQuery({
    index: `${ALERTS_INDEX_PATTERN}${spaceId}`,
    query: {
      ids: {
        values: alertIdsToUpdate
      }
    },
    script: {
      lang: 'painless',
      params: {
        alertIdToAttackIds: alertIdToAttackIdsMap
      },
      source: `
          def alertId = ctx._id;
          def attacksToAdd = params.alertIdToAttackIds.get(alertId);

          if (attacksToAdd != null) {
            if (ctx._source['${_fields.ALERT_ATTACK_IDS}'] == null) {
              ctx._source['${_fields.ALERT_ATTACK_IDS}'] = new ArrayList();
            }

            for (attack in attacksToAdd) {
              if (!ctx._source['${_fields.ALERT_ATTACK_IDS}'].contains(attack)) {
                ctx._source['${_fields.ALERT_ATTACK_IDS}'].add(attack);
              }
            }
          }
        `
    }
  });
}