"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformGetAttackDiscoveryGenerationsSearchResult = void 0;
var _get_attack_discovery_generations_search_result = require("../../get_attack_discovery_generations_search_result");
var _get_generation_status_or_throw = require("./get_generation_status_or_throw");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformGetAttackDiscoveryGenerationsSearchResult = ({
  logger,
  rawResponse
}) => {
  try {
    // validate the raw response:
    const parsed = _get_attack_discovery_generations_search_result.GetAttackDiscoveryGenerationsSearchResult.parse(rawResponse);

    // generate the response, skipping any generations that are missing required fields
    const generations = parsed.aggregations.generations.buckets.flatMap(bucket => {
      const executionUuid = bucket.key;
      try {
        var _bucket$alerts_contex, _bucket$connector_id$, _bucket$discoveries$v, _bucket$event_reason$, _bucket$generation_en, _bucket$generation_en2, _bucket$generation_st, _bucket$loading_messa;
        if (executionUuid == null) {
          throw new Error(`Execution UUID (kibana.alert.rule.execution.uuid) is missing for bucket ${JSON.stringify(bucket)}`);
        }
        const alertsContextCount = (_bucket$alerts_contex = bucket.alerts_context_count.value) !== null && _bucket$alerts_contex !== void 0 ? _bucket$alerts_contex : undefined;
        const connectorId = (_bucket$connector_id$ = bucket.connector_id.buckets[0]) === null || _bucket$connector_id$ === void 0 ? void 0 : _bucket$connector_id$.key;
        const discoveries = (_bucket$discoveries$v = bucket.discoveries.value) !== null && _bucket$discoveries$v !== void 0 ? _bucket$discoveries$v : 0;
        const eventActions = bucket.event_actions.buckets.map(action => action.key);
        const eventReason = (_bucket$event_reason$ = bucket.event_reason.buckets[0]) === null || _bucket$event_reason$ === void 0 ? void 0 : _bucket$event_reason$.key;
        const generationEndTime = (_bucket$generation_en = (_bucket$generation_en2 = bucket.generation_end_time) === null || _bucket$generation_en2 === void 0 ? void 0 : _bucket$generation_en2.value_as_string) !== null && _bucket$generation_en !== void 0 ? _bucket$generation_en : undefined;
        const generationStartTime = (_bucket$generation_st = bucket.generation_start_time) === null || _bucket$generation_st === void 0 ? void 0 : _bucket$generation_st.value_as_string;
        const loadingMessage = (_bucket$loading_messa = bucket.loading_message.buckets[0]) === null || _bucket$loading_messa === void 0 ? void 0 : _bucket$loading_messa.key;
        const status = (0, _get_generation_status_or_throw.getGenerationStatusOrThrow)({
          eventActions,
          executionUuid
        });
        if (connectorId == null) {
          throw new Error(`Connector ID (event.dataset) is missing for executionUuid ${executionUuid}`);
        }
        if (generationStartTime == null) {
          throw new Error(`Generation start (event.start) time is missing for executionUuid ${executionUuid}`);
        }
        if (loadingMessage == null) {
          throw new Error(`Loading message (kibana.alert.rule.execution.status) is missing for executionUuid ${executionUuid}`);
        }
        return {
          alerts_context_count: alertsContextCount,
          connector_id: connectorId,
          discoveries,
          end: generationEndTime,
          loading_message: loadingMessage,
          execution_uuid: executionUuid,
          generation_start_time: generationStartTime,
          reason: eventReason,
          start: generationStartTime,
          status
        };
      } catch (e) {
        logger.debug(() => `Skipping Attack discovery generation search result for execution ${executionUuid != null ? executionUuid : 'unknown executionUuid'}: ${e.message}`);
        return [];
      }
    });
    return {
      generations
    };
  } catch (e) {
    const errorMessage = `Failed to parse search results in transformGetAttackDiscoveryGenerationsSearchResult ${JSON.stringify(e.errors, null, 2)}`;
    logger.error(errorMessage);
    throw new Error(errorMessage);
  }
};
exports.transformGetAttackDiscoveryGenerationsSearchResult = transformGetAttackDiscoveryGenerationsSearchResult;