"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttackDiscoveryScheduleActionsPropsToApi = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isGeneralAction = action => {
  return Object.hasOwn(action, 'group');
};
const transformAttackDiscoveryScheduleActionsPropsToApi = actions => {
  return actions === null || actions === void 0 ? void 0 : actions.map(action => {
    if (isGeneralAction(action)) {
      return {
        action_type_id: action.actionTypeId,
        group: action.group,
        id: action.id,
        params: action.params,
        uuid: action.uuid,
        alerts_filter: action.alertsFilter,
        frequency: action.frequency ? {
          summary: action.frequency.summary,
          notify_when: action.frequency.notifyWhen,
          throttle: action.frequency.throttle
        } : undefined
      };
    }
    return {
      action_type_id: action.actionTypeId,
      id: action.id,
      params: action.params,
      uuid: action.uuid
    };
  });
};
exports.transformAttackDiscoveryScheduleActionsPropsToApi = transformAttackDiscoveryScheduleActionsPropsToApi;