"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceData = exports.SelectOptionInterruptValue = exports.SelectOptionInterruptResumeValue = exports.SelectOptionInterruptOption = exports.SelectOptionInterrupt = exports.SecurityAlertsPageContentReference = exports.SecurityAlertContentReference = exports.Replacements = exports.Reader = exports.ProviderEnum = exports.Provider = exports.ProductDocumentationContentReference = exports.MessageRoleEnum = exports.MessageRole = exports.MessageMetadata = exports.Message = exports.KnowledgeBaseEntryContentReference = exports.InterruptValue = exports.InterruptTypeEnum = exports.InterruptType = exports.InterruptResumeValue = exports.InputTextInterruptValue = exports.InputTextInterruptResumeValue = exports.InputTextInterrupt = exports.HrefContentReference = exports.EsqlContentReference = exports.ErrorSchema = exports.ConversationUpdateProps = exports.ConversationResponse = exports.ConversationMessageCreateProps = exports.ConversationCreateProps = exports.ConversationCategoryEnum = exports.ConversationCategory = exports.ContentReferences = exports.ContentReferenceInternal = exports.ContentReference = exports.BaseInterruptValue = exports.BaseInterruptResumeValue = exports.BaseContentReference = exports.ApiConfig = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Conversation Attributes
 *   version: not applicable
 */

/**
 * Trace Data
 */

const TraceData = exports.TraceData = _zod.z.object({
  /**
   * Could be any string, not necessarily a UUID
   */
  transactionId: _zod.z.string().optional(),
  /**
   * Could be any string, not necessarily a UUID
   */
  traceId: _zod.z.string().optional()
});

/**
 * The type of interrupt
 */

const InterruptType = exports.InterruptType = _zod.z.enum(['SELECT_OPTION', 'INPUT_TEXT']);
const InterruptTypeEnum = exports.InterruptTypeEnum = InterruptType.enum;

/**
 * The basis of an agent interrupt
 */

const BaseInterruptValue = exports.BaseInterruptValue = _zod.z.object({
  /**
   * Type of the interrupt
   */
  type: InterruptType,
  /**
   * Whether the interrupt has expired and can no longer be resumed.
   */
  expired: _zod.z.boolean().optional(),
  /**
   * Thread ID of the graph execution that produced this message.
   */
  threadId: _zod.z.string()
});

/**
 * The basis of an interrupt resume value
 */

const BaseInterruptResumeValue = exports.BaseInterruptResumeValue = _zod.z.object({
  /**
   * Type of the resume value
   */
  type: InterruptType
});

/**
 * A request approval option
 */

const SelectOptionInterruptOption = exports.SelectOptionInterruptOption = _zod.z.object({
  label: _zod.z.string(),
  value: _zod.z.string(),
  buttonColor: _zod.z.enum(['text', 'accent', 'accentSecondary', 'primary', 'success', 'warning', 'danger', 'neutral', 'risk']).optional()
});

/**
 * Interrupt that requests user to select one of the provided options
 */

const SelectOptionInterruptValue = exports.SelectOptionInterruptValue = BaseInterruptValue.merge(_zod.z.object({
  type: _zod.z.literal('SELECT_OPTION'),
  /**
   * Description of action required
   */
  description: _zod.z.string(),
  /**
   * List of actions to choose from
   */
  options: _zod.z.array(SelectOptionInterruptOption)
}));

/**
 * A request approval resume schema
 */

const SelectOptionInterruptResumeValue = exports.SelectOptionInterruptResumeValue = BaseInterruptResumeValue.merge(_zod.z.object({
  type: _zod.z.literal('SELECT_OPTION'),
  /**
   * The value of the selected option to resume the graph execution with
   */
  value: _zod.z.string()
}));

/**
 * A request approval interrupt
 */

const SelectOptionInterrupt = exports.SelectOptionInterrupt = _zod.z.object({
  /**
   * The interrupt value
   */
  interruptValue: SelectOptionInterruptValue,
  /**
   * The resume value
   */
  resumeValue: SelectOptionInterruptResumeValue
});

/**
 * Interrupt that requests user to provide text input
 */

const InputTextInterruptValue = exports.InputTextInterruptValue = BaseInterruptValue.merge(_zod.z.object({
  type: _zod.z.literal('INPUT_TEXT'),
  /**
   * Description of action required
   */
  description: _zod.z.string().optional(),
  /**
   * Placeholder text for the input field
   */
  placeholder: _zod.z.string().optional()
}));

/**
 * A resume value for input text
 */

const InputTextInterruptResumeValue = exports.InputTextInterruptResumeValue = BaseInterruptResumeValue.merge(_zod.z.object({
  type: _zod.z.literal('INPUT_TEXT'),
  /**
   * Text value used to resume the graph execution with.
   */
  value: _zod.z.string()
}));

/**
 * A request text interrupt
 */

const InputTextInterrupt = exports.InputTextInterrupt = _zod.z.object({
  /**
   * The interrupt value
   */
  interruptValue: InputTextInterruptValue,
  /**
   * The resume value
   */
  resumeValue: InputTextInterruptResumeValue
});

/**
 * Union of the interrupt values
 */

const InterruptValue = exports.InterruptValue = _zod.z.union([SelectOptionInterruptValue, InputTextInterruptValue]);

/**
 * Union of the interrupt resume values
 */

const InterruptResumeValue = exports.InterruptResumeValue = _zod.z.union([SelectOptionInterruptResumeValue, InputTextInterruptResumeValue]);

/**
 * The basis of a content reference
 */

const BaseContentReference = exports.BaseContentReference = _zod.z.object({
  /**
   * Id of the content reference
   */
  id: _zod.z.string(),
  /**
   * Type of the content reference
   */
  type: _zod.z.string()
});

/**
 * References a knowledge base entry
 */

const KnowledgeBaseEntryContentReference = exports.KnowledgeBaseEntryContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('KnowledgeBaseEntry'),
  /**
   * Id of the Knowledge Base Entry
   */
  knowledgeBaseEntryId: _zod.z.string(),
  /**
   * Name of the knowledge base entry
   */
  knowledgeBaseEntryName: _zod.z.string()
}));

/**
 * References an ESQL query
 */

const EsqlContentReference = exports.EsqlContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('EsqlQuery'),
  /**
   * An ESQL query
   */
  query: _zod.z.string(),
  /**
   * Label of the query
   */
  label: _zod.z.string(),
  /**
   * Time range to select in the time picker.
   */
  timerange: _zod.z.object({
    from: _zod.z.string(),
    to: _zod.z.string()
  }).optional()
}));

/**
 * References a security alert
 */

const SecurityAlertContentReference = exports.SecurityAlertContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('SecurityAlert'),
  /**
   * ID of the Alert
   */
  alertId: _zod.z.string()
}));

/**
 * References an external URL
 */

const HrefContentReference = exports.HrefContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('Href'),
  /**
   * Label of the query
   */
  label: _zod.z.string().optional(),
  /**
   * URL to the external resource
   */
  href: _zod.z.string()
}));

/**
 * References the security alerts page
 */

const SecurityAlertsPageContentReference = exports.SecurityAlertsPageContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('SecurityAlertsPage')
}));

/**
 * References the product documentation
 */

const ProductDocumentationContentReference = exports.ProductDocumentationContentReference = BaseContentReference.merge(_zod.z.object({
  type: _zod.z.literal('ProductDocumentation'),
  /**
   * Title of the documentation
   */
  title: _zod.z.string(),
  /**
   * URL to the documentation
   */
  url: _zod.z.string()
}));

/**
 * A content reference
 */
const ContentReferenceInternal = exports.ContentReferenceInternal = _zod.z.union([KnowledgeBaseEntryContentReference, SecurityAlertContentReference, SecurityAlertsPageContentReference, ProductDocumentationContentReference, EsqlContentReference, HrefContentReference]);
const ContentReference = exports.ContentReference = ContentReferenceInternal;

/**
 * A union of all content reference types
 */

const ContentReferences = exports.ContentReferences = _zod.z.object({}).catchall(_zod.z.union([KnowledgeBaseEntryContentReference, SecurityAlertContentReference, SecurityAlertsPageContentReference, ProductDocumentationContentReference, EsqlContentReference, HrefContentReference]));

/**
 * Message metadata
 */

const MessageMetadata = exports.MessageMetadata = _zod.z.object({
  /**
   * Data referred to by the message content.
   */
  contentReferences: ContentReferences.optional(),
  /**
   * When the agent is interrupted (for example, when user input is required), this field is populated with the details of the interrupt. Messages containing interruptValues in the metadata are excluded from the LLM context.
   */
  interruptValue: InterruptValue.optional(),
  /**
   * When the agent is resumed after an interrupt, this field is populated with the details of the resume value.
   */
  interruptResumeValue: InterruptResumeValue.optional()
});

/**
 * Replacements object used to anonymize/deanonymize messages
 */

const Replacements = exports.Replacements = _zod.z.object({}).catchall(_zod.z.string());
const Reader = exports.Reader = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * Provider
 */

const Provider = exports.Provider = _zod.z.enum(['OpenAI', 'Azure OpenAI', 'Other']);
const ProviderEnum = exports.ProviderEnum = Provider.enum;

/**
 * Message role.
 */

const MessageRole = exports.MessageRole = _zod.z.enum(['system', 'user', 'assistant']);
const MessageRoleEnum = exports.MessageRoleEnum = MessageRole.enum;

/**
 * The conversation category.
 */

const ConversationCategory = exports.ConversationCategory = _zod.z.enum(['assistant', 'insights']);
const ConversationCategoryEnum = exports.ConversationCategoryEnum = ConversationCategory.enum;

/**
 * AI assistant conversation message.
 */

const Message = exports.Message = _zod.z.object({
  /**
   * Message id
   */
  id: _common_attributes.NonEmptyString.optional(),
  /**
   * Message content.
   */
  content: _zod.z.string(),
  /**
   * Refusal reason returned by the model when content is filtered.
   */
  refusal: _zod.z.string().optional(),
  /**
   * Message content.
   */
  reader: Reader.optional(),
  /**
   * Message role.
   */
  role: MessageRole,
  /**
   * The user who sent the message.
   */
  user: _common_attributes.User.optional(),
  /**
   * The timestamp message was sent or received.
   */
  timestamp: _common_attributes.NonEmptyTimestamp,
  /**
   * Is error message.
   */
  isError: _zod.z.boolean().optional(),
  /**
   * Trace data
   */
  traceData: TraceData.optional(),
  /**
   * Metadata
   */
  metadata: MessageMetadata.optional()
});
const ApiConfig = exports.ApiConfig = _zod.z.object({
  /**
   * Connector ID
   */
  connectorId: _zod.z.string(),
  /**
   * Action type ID
   */
  actionTypeId: _zod.z.string(),
  /**
   * Default system prompt ID
   */
  defaultSystemPromptId: _zod.z.string().optional(),
  /**
   * Provider
   */
  provider: Provider.optional(),
  /**
   * Model
   */
  model: _zod.z.string().optional()
});
const ErrorSchema = exports.ErrorSchema = _zod.z.object({
  id: _common_attributes.NonEmptyString.optional(),
  error: _zod.z.object({
    status_code: _zod.z.number().int().min(400),
    message: _zod.z.string()
  })
}).strict();
const ConversationResponse = exports.ConversationResponse = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * The conversation title.
   */
  title: _zod.z.string(),
  /**
   * The conversation category.
   */
  category: ConversationCategory,
  timestamp: _common_attributes.NonEmptyTimestamp.optional(),
  /**
   * The last time conversation was updated.
   */
  updatedAt: _zod.z.string().optional(),
  /**
   * The time conversation was created.
   */
  createdAt: _zod.z.string(),
  replacements: Replacements.optional(),
  /**
   * The user who created the conversation.
   */
  createdBy: _common_attributes.User,
  users: _zod.z.array(_common_attributes.User),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  /**
   * Exclude from last conversation storage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  /**
   * Kibana space
   */
  namespace: _zod.z.string()
});
const ConversationUpdateProps = exports.ConversationUpdateProps = _zod.z.object({
  id: _common_attributes.NonEmptyString,
  /**
   * The conversation title.
   */
  title: _zod.z.string().optional(),
  /**
   * The conversation category.
   */
  category: ConversationCategory.optional(),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  /**
   * Exclude from last conversation storage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  replacements: Replacements.optional(),
  users: _zod.z.array(_common_attributes.User).optional()
});
const ConversationCreateProps = exports.ConversationCreateProps = _zod.z.object({
  /**
   * The conversation id.
   */
  id: _zod.z.string().optional(),
  /**
   * The conversation title.
   */
  title: _zod.z.string(),
  /**
   * The conversation category.
   */
  category: ConversationCategory.optional(),
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message).optional(),
  /**
   * LLM API configuration.
   */
  apiConfig: ApiConfig.optional(),
  /**
   * Exclude from last conversation storage.
   */
  excludeFromLastConversationStorage: _zod.z.boolean().optional(),
  replacements: Replacements.optional()
});
const ConversationMessageCreateProps = exports.ConversationMessageCreateProps = _zod.z.object({
  /**
   * The conversation messages.
   */
  messages: _zod.z.array(Message)
});