"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocLinks = void 0;
var _std = require("@kbn/std");
var _get_doc_meta = require("./get_doc_meta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDocLinks = ({
  kibanaBranch,
  buildFlavor
}) => {
  const meta = (0, _get_doc_meta.getDocLinksMeta)({
    kibanaBranch,
    buildFlavor
  });
  const DOC_LINK_VERSION = meta.version;
  const ELASTIC_WEBSITE_URL = meta.elasticWebsiteUrl;
  const ELASTIC_GITHUB = meta.elasticGithubUrl;
  const SEARCH_LABS_URL = meta.searchLabsUrl;
  const API_DOCS = meta.apiDocsUrl;
  const ELASTIC_DOCS = meta.docsWebsiteUrl;
  const ELASTICSEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/reference/${DOC_LINK_VERSION}/`;
  const ELASTICSEARCH_APIS = `${API_DOCS}doc/elasticsearch/`;
  const ELASTICSEARCH_SERVERLESS_APIS = `${API_DOCS}doc/elasticsearch-serverless/`;
  const KIBANA_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/kibana/${DOC_LINK_VERSION}/`;
  const KIBANA_APIS = `${API_DOCS}doc/kibana/`;
  const KIBANA_SERVERLESS_APIS = `${API_DOCS}doc/serverless/`;
  const SECURITY_SOLUTION_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/security/${DOC_LINK_VERSION}/`;
  const ENTERPRISE_SEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/enterprise-search/${DOC_LINK_VERSION}/`;
  const ESRE_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/esre/${DOC_LINK_VERSION}/`;
  const SEARCH_LABS_REPO = `${ELASTIC_GITHUB}elasticsearch-labs/`;
  const isServerless = buildFlavor === 'serverless';
  return (0, _std.deepFreeze)({
    settings: `${ELASTIC_DOCS}reference/kibana/configuration-reference`,
    aiAssistantSettings: `${ELASTIC_DOCS}reference/kibana/configuration-reference/ai-assistant-settings`,
    elasticStackGetStarted: isServerless ? `${ELASTIC_DOCS}deploy-manage/deploy/elastic-cloud/serverless` : `${ELASTIC_DOCS}get-started`,
    apiReference: `${API_DOCS}`,
    serverlessReleaseNotes: `${ELASTIC_DOCS}release-notes/cloud-serverless`,
    upgrade: {
      upgradingStackOnPrem: `${ELASTIC_DOCS}deploy-manage/upgrade/deployment-or-cluster`,
      upgradingStackOnCloud: `${ELASTIC_DOCS}deploy-manage/upgrade/deployment-or-cluster`
    },
    apm: {
      kibanaSettings: `${ELASTIC_DOCS}solutions/observability/apm/applications-ui-settings`,
      supportedServiceMaps: `${ELASTIC_DOCS}solutions/observability/apm/service-map`,
      customLinks: `${ELASTIC_DOCS}solutions/observability/apm/create-custom-links`,
      droppedTransactionSpans: `${ELASTIC_DOCS}solutions/observability/apm/spans#apm-data-model-dropped-spans`,
      upgrading: `${ELASTIC_DOCS}solutions/observability/apm/upgrade`,
      metaData: `${ELASTIC_DOCS}solutions/observability/apm/metadata`,
      overview: `${ELASTIC_DOCS}solutions/observability/apm`,
      tailSamplingPolicies: `${ELASTIC_DOCS}solutions/observability/apm/transaction-sampling`,
      elasticAgent: `${ELASTIC_DOCS}solutions/observability/apm/switch-to-elastic-apm-integration`,
      storageExplorer: `${ELASTIC_DOCS}solutions/observability/apm/storage-explorer`,
      spanCompression: `${ELASTIC_DOCS}solutions/observability/apm/spans`,
      transactionSampling: `${ELASTIC_DOCS}solutions/observability/apm/transaction-sampling`,
      indexLifecycleManagement: `${ELASTIC_DOCS}solutions/observability/apm/index-lifecycle-management`
    },
    canvas: {
      guide: `${ELASTIC_DOCS}explore-analyze/visualize/canvas`
    },
    cloud: {
      beatsAndLogstashConfiguration: `${ELASTIC_DOCS}deploy-manage/deploy/elastic-cloud/find-cloud-id`,
      elasticsearchBillingManagingCosts: `${ELASTIC_DOCS}deploy-manage/cloud-organization/billing/elasticsearch-billing-dimensions#elasticsearch-billing-managing-elasticsearch-costs`,
      indexManagement: `${ELASTIC_DOCS}manage-data/lifecycle/index-lifecycle-management/migrate-index-management`,
      cloudConnect: `${ELASTIC_DOCS}deploy-manage/cloud-connect`,
      connectToAutoops: `${ELASTIC_DOCS}deploy-manage/monitor/autoops/cc-autoops-as-cloud-connected`
    },
    console: {
      guide: `${ELASTIC_DOCS}explore-analyze/query-filter/tools/console`
    },
    dashboard: {
      guide: `${ELASTIC_DOCS}explore-analyze/dashboards`,
      drilldowns: `${ELASTIC_DOCS}explore-analyze/dashboards/drilldowns`,
      drilldownsTriggerPicker: `${ELASTIC_DOCS}explore-analyze/dashboards/drilldowns#create-url-drilldowns`,
      urlDrilldownTemplateSyntax: `${ELASTIC_DOCS}explore-analyze/dashboards/drilldowns#url-templating-language`,
      urlDrilldownVariables: `${ELASTIC_DOCS}explore-analyze/dashboards/drilldowns#url-template-variable`
    },
    discover: {
      guide: `${ELASTIC_DOCS}explore-analyze/discover`,
      fieldStatistics: `${ELASTIC_DOCS}explore-analyze/discover/show-field-statistics`,
      fieldTypeHelp: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/field-data-types`,
      dateFieldTypeDocs: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/date`,
      dateFormatsDocs: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-date-format`,
      documentExplorer: `${ELASTIC_DOCS}explore-analyze/discover/document-explorer`
    },
    filebeat: {
      base: `${ELASTIC_DOCS}reference/beats/filebeat`,
      installation: `${ELASTIC_DOCS}reference/beats/filebeat/filebeat-installation-configuration`,
      configuration: `${ELASTIC_DOCS}reference/beats/filebeat/configuring-howto-filebeat`,
      elasticsearchModule: `${ELASTIC_DOCS}reference/beats/filebeat/filebeat-module-elasticsearch`,
      elasticsearchOutput: `${ELASTIC_DOCS}reference/beats/filebeat/elasticsearch-output`,
      startup: `${ELASTIC_DOCS}reference/beats/filebeat/filebeat-starting`,
      exportedFields: `${ELASTIC_DOCS}reference/beats/filebeat/exported-fields`,
      suricataModule: `${ELASTIC_DOCS}reference/beats/filebeat/filebeat-module-suricata`,
      zeekModule: `${ELASTIC_DOCS}reference/beats/filebeat/filebeat-module-zeek`
    },
    auditbeat: {
      base: `${ELASTIC_DOCS}reference/beats/auditbeat`,
      auditdModule: `${ELASTIC_DOCS}reference/beats/auditbeat/auditbeat-module-auditd`,
      systemModule: `${ELASTIC_DOCS}reference/beats/auditbeat/auditbeat-module-system`
    },
    enterpriseSearch: {
      aiSearchDoc: `${ESRE_DOCS}`,
      aiSearchHelp: `${ESRE_DOCS}help.html`,
      apiKeys: `${ELASTIC_DOCS}deploy-manage/api-keys/elasticsearch-api-keys`,
      behavioralAnalytics: `${ELASTICSEARCH_DOCS}behavioral-analytics-overview.html`,
      behavioralAnalyticsCORS: `${ELASTICSEARCH_DOCS}behavioral-analytics-cors.html`,
      behavioralAnalyticsEvents: `${ELASTICSEARCH_DOCS}behavioral-analytics-event.html`,
      buildConnector: `${ELASTIC_DOCS}reference/search-connectors/self-managed-connectors`,
      bulkApi: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-bulk` : `${ELASTICSEARCH_APIS}operation/operation-bulk`,
      configuration: `${ENTERPRISE_SEARCH_DOCS}configuration.html`,
      connectors: `${ELASTIC_DOCS}reference/search-connectors`,
      connectorsClientDeploy: `${ELASTIC_DOCS}reference/search-connectors/self-managed-connectors#es-connectors-deploy-connector-service`,
      connectorsMappings: `${ELASTIC_DOCS}reference/search-connectors/connectors-ui-in-kibana#es-connectors-usage-index-create-configure-existing-index`,
      connectorsAzureBlobStorage: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-azure-blob`,
      connectorsBox: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-box`,
      connectorsClients: `${ELASTIC_DOCS}reference/search-connectors`,
      connectorsConfluence: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-confluence`,
      connectorsDropbox: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-dropbox`,
      connectorsContentExtraction: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-content-extraction`,
      connectorsGithub: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-github`,
      connectorsGitlab: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-gitlab`,
      connectorsGmail: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-gmail`,
      connectorsGoogleCloudStorage: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-google-cloud`,
      connectorsGoogleDrive: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-google-drive`,
      connectorsJira: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-jira`,
      connectorsMicrosoftSQL: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-ms-sql`,
      connectorsMongoDB: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-mongodb`,
      connectorsMySQL: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-mysql`,
      connectorsNative: `${ELASTIC_DOCS}reference/search-connectors#es-connectors-native`,
      connectorsNetworkDrive: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-network-drive`,
      connectorsNotion: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-notion`,
      connectorsOneDrive: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-onedrive`,
      connectorsOracle: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-oracle`,
      connectorsOutlook: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-outlook`,
      connectorsPostgreSQL: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-postgresql`,
      connectorsRedis: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-redis`,
      connectorsS3: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-s3`,
      connectorsSalesforce: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-salesforce`,
      connectorsServiceNow: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-servicenow`,
      connectorsSharepoint: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-sharepoint`,
      connectorsSharepointOnline: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-sharepoint-online`,
      connectorsSlack: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-slack`,
      connectorsTeams: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-teams`,
      connectorsZoom: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-zoom`,
      crawlerExtractionRules: `${ENTERPRISE_SEARCH_DOCS}crawler-extraction-rules.html`,
      crawlerManaging: `${ENTERPRISE_SEARCH_DOCS}crawler-managing.html`,
      crawlerOverview: `${ENTERPRISE_SEARCH_DOCS}crawler.html`,
      deployTrainedModels: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-deploy-models`,
      documentLevelSecurity: `${ELASTIC_DOCS}deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level`,
      e5Model: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-e5`,
      elasticInferenceService: `${ELASTIC_DOCS}explore-analyze/elastic-inference/eis`,
      elasticInferenceServicePricing: `${ELASTIC_DOCS}explore-analyze/elastic-inference/eis#pricing`,
      elser: `${ELASTIC_DOCS}solutions/search/semantic-search/semantic-search-semantic-text`,
      engines: `${ENTERPRISE_SEARCH_DOCS}engines.html`,
      indexApi: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-create` : `${ELASTICSEARCH_APIS}operation/operation-create`,
      inferenceApiCreate: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-inference-put` : `${ELASTICSEARCH_APIS}operation/operation-inference-put`,
      inferenceApisConfigureChunking: `${ELASTIC_DOCS}explore-analyze/elastic-inference/inference-api#infer-chunking-config`,
      ingestionApis: `${ELASTIC_DOCS}solutions/search`,
      ingestPipelines: `${ELASTIC_DOCS}solutions/search/search-pipelines`,
      knnSearch: `${ELASTIC_DOCS}solutions/search/vector/knn`,
      knnSearchCombine: `${ELASTIC_DOCS}solutions/search/vector/knn#_combine_approximate_knn_with_other_features`,
      languageAnalyzers: `${ELASTIC_DOCS}reference/text-analysis/analysis-lang-analyzer`,
      languageClients: `${ENTERPRISE_SEARCH_DOCS}programming-language-clients.html`,
      licenseManagement: `${ENTERPRISE_SEARCH_DOCS}license-management.html`,
      machineLearningStart: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/nlp-end-to-end-tutorial`,
      mailService: `${ENTERPRISE_SEARCH_DOCS}mailer-configuration.html`,
      mlDocumentEnrichment: `${ELASTIC_DOCS}explore-analyze/machine-learning/machine-learning-in-kibana/inference-processing`,
      searchApplicationsTemplates: `${ELASTIC_DOCS}solutions/search/search-applications/search-application-api`,
      searchApplicationsSearchApi: `${ELASTIC_DOCS}solutions/search/search-applications/search-application-security`,
      searchApplications: `${ELASTIC_DOCS}solutions/search/search-applications`,
      searchApplicationsSearch: `${ELASTIC_DOCS}solutions/search/search-applications/search-application-client`,
      searchLabs: `${SEARCH_LABS_URL}`,
      searchLabsRepo: `${SEARCH_LABS_REPO}`,
      semanticSearch: `${ELASTIC_DOCS}solutions/search/semantic-search`,
      searchTemplates: `${ELASTIC_DOCS}solutions/search/search-templates`,
      semanticTextField: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/semantic-text`,
      start: `${ENTERPRISE_SEARCH_DOCS}start.html`,
      supportedNlpModels: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-model-ref`,
      syncRules: `${ELASTIC_DOCS}reference/search-connectors/es-sync-rules`,
      syncRulesAdvanced: `${ELASTIC_DOCS}reference/search-connectors/es-sync-rules#es-sync-rules-advanced`,
      trainedModels: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-trained-models`,
      textEmbedding: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-model-ref#ml-nlp-model-ref-text-embedding`,
      troubleshootSetup: `${ENTERPRISE_SEARCH_DOCS}troubleshoot-setup.html`,
      upgrade9x: `${ENTERPRISE_SEARCH_DOCS}upgrading-to-9-x.html`,
      usersAccess: `${ENTERPRISE_SEARCH_DOCS}users-access.html`
    },
    searchHomepage: {
      visitSearchLabs: `${ELASTIC_WEBSITE_URL}search-labs`,
      notebooksExamples: `${ELASTIC_WEBSITE_URL}search-labs/tutorials/examples`,
      customerEngineerRequestForm: `${ELASTIC_WEBSITE_URL}contact/ce-help`,
      elasticCommunity: `${ELASTIC_WEBSITE_URL}community/`,
      elasticCloud: `${ELASTIC_WEBSITE_URL}cloud/`
    },
    searchGettingStarted: {
      visitSearchLabs: `${ELASTIC_WEBSITE_URL}search-labs`,
      notebooksExamples: `${ELASTIC_WEBSITE_URL}search-labs/tutorials/examples`,
      elasticTraining: `${ELASTIC_WEBSITE_URL}training`
    },
    metricbeat: {
      base: `${ELASTIC_DOCS}reference/beats/metricbeat`,
      configure: `${ELASTIC_DOCS}reference/beats/metricbeat/configuring-howto-metricbeat`,
      httpEndpoint: `${ELASTIC_DOCS}reference/beats/metricbeat/http-endpoint`,
      install: `${ELASTIC_DOCS}reference/beats/metricbeat/metricbeat-installation-configuration`,
      start: `${ELASTIC_DOCS}reference/beats/metricbeat/metricbeat-starting`
    },
    heartbeat: {
      base: `${ELASTIC_DOCS}reference/beats/heartbeat`,
      monitorTags: `${ELASTIC_DOCS}reference/beats/heartbeat/monitor-options#monitor-tags`
    },
    libbeat: {
      getStarted: `${ELASTIC_DOCS}reference/beats`
    },
    logstash: {
      base: `${ELASTIC_DOCS}reference/logstash`,
      inputElasticAgent: `${ELASTIC_DOCS}reference/logstash/plugins/plugins-inputs-elastic_agent`
    },
    winlogbeat: {
      base: `${ELASTIC_DOCS}reference/beats/winlogbeat`
    },
    aggs: {
      composite: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-composite-aggregation`,
      composite_missing_bucket: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-composite-aggregation#_missing_bucket`,
      date_histogram: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-datehistogram-aggregation`,
      date_range: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-daterange-aggregation`,
      date_format_pattern: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-daterange-aggregation#date-format-pattern`,
      filter: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-filter-aggregation`,
      filters: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-filters-aggregation`,
      geohash_grid: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-geohashgrid-aggregation`,
      histogram: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-histogram-aggregation`,
      ip_range: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-iprange-aggregation`,
      range: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-range-aggregation`,
      significant_terms: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-significantterms-aggregation`,
      terms: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-terms-aggregation`,
      terms_doc_count_error: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-terms-aggregation#_per_bucket_document_count_error`,
      rare_terms: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-bucket-rare-terms-aggregation`,
      avg: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-avg-aggregation`,
      avg_bucket: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-pipeline-avg-bucket-aggregation`,
      max_bucket: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-pipeline-max-bucket-aggregation`,
      min_bucket: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-pipeline-min-bucket-aggregation`,
      sum_bucket: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-pipeline-sum-bucket-aggregation`,
      cardinality: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-cardinality-aggregation`,
      count: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-valuecount-aggregation`,
      cumulative_sum: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-sum-aggregation`,
      derivative: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-pipeline-derivative-aggregation`,
      geo_bounds: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-geobounds-aggregation`,
      geo_centroid: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-geocentroid-aggregation`,
      max: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-max-aggregation`,
      median: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-percentile-aggregation`,
      min: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-min-aggregation`,
      moving_avg: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-pipeline-movfn-aggregation`,
      percentile_ranks: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-percentile-rank-aggregation`,
      serial_diff: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-pipeline-serialdiff-aggregation`,
      std_dev: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-extendedstats-aggregation`,
      sum: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-sum-aggregation`,
      top_hits: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-top-hits-aggregation`,
      top_metrics: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-metrics-top-metrics`,
      change_point: `${ELASTIC_DOCS}reference/aggregations/search-aggregations-change-point-aggregation`
    },
    runtimeFields: {
      overview: `${ELASTIC_DOCS}manage-data/data-store/mapping/runtime-fields`,
      mapping: `${ELASTIC_DOCS}manage-data/data-store/mapping/map-runtime-field`
    },
    scriptedFields: {
      scriptFields: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/retrieve-selected-fields#script-fields`,
      scriptAggs: `${ELASTIC_DOCS}explore-analyze/query-filter/aggregations`,
      painless: `${ELASTIC_DOCS}explore-analyze/scripting/modules-scripting-painless`,
      painlessApi: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-scripts-painless-execute` : `${ELASTICSEARCH_APIS}operation/operation-scripts-painless-execute`,
      painlessLangSpec: `${ELASTIC_DOCS}reference/scripting-languages/painless/painless-language-specification`,
      painlessSyntax: `${ELASTIC_DOCS}reference/scripting-languages/painless/painless-language-specification`,
      painlessWalkthrough: `${ELASTIC_DOCS}reference/scripting-languages/painless/brief-painless-walkthrough`,
      painlessLanguage: `${ELASTIC_DOCS}reference/scripting-languages/painless/painless-language-specification`,
      luceneExpressions: `${ELASTIC_DOCS}explore-analyze/scripting/modules-scripting-expression`
    },
    indexPatterns: {
      introduction: `${ELASTIC_DOCS}explore-analyze/find-and-organize/data-views`,
      fieldFormattersNumber: `${ELASTIC_DOCS}explore-analyze/numeral-formatting`,
      fieldFormattersString: `${ELASTIC_DOCS}explore-analyze/find-and-organize/data-views#string-field-formatters`,
      runtimeFields: `${ELASTIC_DOCS}explore-analyze/find-and-organize/data-views#runtime-fields`,
      migrateOffScriptedFields: `${ELASTIC_DOCS}explore-analyze/find-and-organize/data-views#migrate-off-scripted-fields`
    },
    addData: `${ELASTIC_DOCS}manage-data/ingest`,
    kibana: {
      askElastic: `${ELASTIC_WEBSITE_URL}products/kibana/ask-elastic?blade=kibanaaskelastic`,
      createGithubIssue: `${ELASTIC_GITHUB}kibana/issues/new/choose`,
      feedback: `${ELASTIC_WEBSITE_URL}products/kibana/feedback?blade=kibanafeedback`,
      guide: `${ELASTIC_DOCS}get-started/the-stack`,
      autocompleteSuggestions: `${ELASTIC_DOCS}explore-analyze/query-filter/filtering#autocomplete-suggestions`,
      secureSavedObject: `${ELASTIC_DOCS}deploy-manage/security/secure-saved-objects`,
      xpackSecurity: `${ELASTIC_DOCS}deploy-manage/security`,
      restApis: isServerless ? `${KIBANA_SERVERLESS_APIS}` : `${KIBANA_APIS}`,
      upgradeNotes: `${ELASTIC_DOCS}release-notes/kibana/breaking-changes`
    },
    upgradeAssistant: {
      overview: `${ELASTIC_DOCS}deploy-manage/upgrade/prepare-to-upgrade/upgrade-assistant`,
      batchReindex: `${KIBANA_APIS}group/endpoint-upgrade`,
      indexBlocks: `${ELASTIC_DOCS}reference/elasticsearch/index-settings/index-block#index-block-settings`,
      remoteReindex: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-reindex` : `${ELASTICSEARCH_APIS}operation/operation-reindex`,
      unfreezeApi: `https://www.elastic.co/guide/en/elastic-stack/9.0/release-notes-elasticsearch-9.0.0.html#remove_unfreeze_rest_endpoint`,
      reindexWithPipeline: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-reindex` : `${ELASTICSEARCH_APIS}operation/operation-reindex`,
      logsDatastream: `${ELASTIC_DOCS}manage-data/data-store/data-streams/logs-data-stream`,
      usingLogsDbIndexModeWithESSecurity: `${ELASTIC_DOCS}solutions/security/detect-and-alert/using-logsdb-index-mode-with-elastic-security`,
      dataStreamReindex: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/reindex-data-stream#reindex-data-stream-api-settings`
    },
    rollupJobs: `${ELASTIC_DOCS}manage-data/lifecycle/rollup/getting-started-kibana`,
    elasticsearch: {
      docsBase: `${ELASTIC_DOCS}solutions/search`,
      asyncSearch: `${ELASTIC_DOCS}solutions/search/async-search-api`,
      dataStreams: `${ELASTIC_DOCS}manage-data/data-store/data-streams`,
      deprecationLogging: `${ELASTIC_DOCS}deploy-manage/monitor/logging-configuration/update-elasticsearch-logging-levels#deprecation-logging`,
      createEnrichPolicy: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-enrich-put-policy` : `${ELASTICSEARCH_APIS}operation/operation-enrich-put-policy`,
      matchAllQuery: `${ELASTIC_DOCS}reference/query-languages/query-dsl/query-dsl-match-all-query`,
      enrichPolicies: `${ELASTIC_DOCS}manage-data/ingest/transform-enrich/data-enrichment#enrich-policy`,
      createIndex: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-indices-create` : `${ELASTICSEARCH_APIS}operation/operation-indices-create`,
      createIndexParameters: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-indices-create#operation-indices-create-path` : `${ELASTICSEARCH_APIS}operation/operation-indices-create#operation-indices-create-path`,
      gettingStarted: `${ELASTIC_DOCS}solutions/search/get-started`,
      hiddenIndices: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/api-conventions#multi-hidden`,
      ilm: `${ELASTIC_DOCS}manage-data/lifecycle/index-lifecycle-management`,
      ilmForceMerge: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-forcemerge`,
      ilmFreeze: `${ELASTIC_WEBSITE_URL}blog/significantly-decrease-your-elasticsearch-heap-memory-usage`,
      ilmDelete: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-delete`,
      ilmPhaseTransitions: `${ELASTIC_DOCS}manage-data/lifecycle/index-lifecycle-management/index-lifecycle#ilm-phase-transitions`,
      ilmReadOnly: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-readonly`,
      ilmRollover: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-rollover`,
      ilmSearchableSnapshot: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-searchable-snapshot`,
      ilmSetPriority: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-set-priority`,
      ilmShrink: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-shrink`,
      ilmWaitForSnapshot: `${ELASTIC_DOCS}reference/elasticsearch/index-lifecycle-actions/ilm-wait-for-snapshot`,
      indexModules: `${ELASTIC_DOCS}reference/elasticsearch/index-settings/index-modules`,
      indexSettings: `${ELASTIC_DOCS}reference/elasticsearch/index-settings`,
      dynamicIndexSettings: `${ELASTIC_DOCS}reference/elasticsearch/index-settings/index-modules#dynamic-index-settings`,
      indexTemplates: `${ELASTIC_DOCS}manage-data/data-store/templates`,
      mapping: `${ELASTIC_DOCS}manage-data/data-store/mapping`,
      mappingReference: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference`,
      mappingAnalyzer: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/analyzer`,
      mappingCoerce: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/coerce`,
      mappingCopyTo: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/copy-to`,
      mappingDocValues: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/doc-values`,
      mappingDynamic: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/dynamic`,
      mappingDynamicFields: `${ELASTIC_DOCS}manage-data/data-store/mapping/dynamic-field-mapping`,
      mappingDynamicTemplates: `${ELASTIC_DOCS}manage-data/data-store/mapping/dynamic-templates`,
      mappingEagerGlobalOrdinals: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/eager-global-ordinals`,
      mappingEnabled: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/enabled`,
      mappingFieldData: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/text#fielddata-mapping-param`,
      mappingFieldDataEnable: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/text#before-enabling-fielddata`,
      mappingFieldDataFilter: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/text#field-data-filtering`,
      mappingFieldDataTypes: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/field-data-types`,
      mappingFormat: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-date-format`,
      mappingIgnoreAbove: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/ignore-above`,
      mappingIgnoreMalformed: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/ignore-malformed`,
      mappingIndex: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-index`,
      mappingIndexOptions: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/index-options`,
      mappingIndexPhrases: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/index-phrases`,
      mappingIndexPrefixes: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/index-prefixes`,
      mappingJoinFieldsPerformance: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/parent-join#_parent_join_and_performance`,
      mappingMeta: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-field-meta`,
      mappingMetaFields: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-meta-field`,
      mappingMultifields: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/multi-fields`,
      mappingNormalizer: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/normalizer`,
      mappingNorms: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/norms`,
      mappingNullValue: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/null-value`,
      mappingParameters: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-parameters`,
      mappingPositionIncrementGap: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/position-increment-gap`,
      mappingRankFeatureFields: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/rank-feature`,
      mappingRouting: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-routing-field`,
      mappingSettingsLimit: `${ELASTIC_DOCS}reference/elasticsearch/index-settings/mapping-limit`,
      mappingSimilarity: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/similarity`,
      mappingSourceFields: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-source-field`,
      mappingSourceFieldsDisable: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-source-field#disable-source-field`,
      mappingSyntheticSourceFields: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source`,
      mappingStore: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/mapping-store`,
      mappingSubobjects: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/subobjects`,
      mappingTermVector: `${ELASTIC_DOCS}reference/elasticsearch/mapping-reference/term-vector`,
      mappingTypesRemoval: `${ELASTIC_DOCS}manage-data/data-store/mapping/removal-of-mapping-types`,
      migrateIndexAllocationFilters: `${ELASTIC_DOCS}manage-data/lifecycle/index-lifecycle-management/migrate-index-allocation-filters-to-node-roles`,
      migrationApiDeprecation: `${ELASTICSEARCH_APIS}operation/operation-migration-deprecations`,
      nodeRoles: `${ELASTIC_DOCS}reference/elasticsearch/configuration-reference/node-settings#node-roles`,
      reindexDatastreamApiSettings: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/reindex-data-stream#reindex-data-stream-api-settings`,
      releaseHighlights: `${ELASTIC_DOCS}release-notes/elasticsearch`,
      latestReleaseHighlights: `${ELASTIC_DOCS}release-notes`,
      remoteClusters: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-self-managed`,
      remoteClustersProxy: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-self-managed#proxy-mode`,
      remoteClusersProxySettings: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-settings#remote-cluster-proxy-settings`,
      remoteClustersOnPremSetupTrustWithCert: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-cert`,
      remoteClustersOnPremSetupTrustWithApiKey: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-api-key`,
      remoteClustersCloudSetupTrust: `${ELASTIC_DOCS}deploy-manage/remote-clusters/ec-enable-ccs`,
      remoteClustersCreateCloudClusterApiKey: `${ELASTICSEARCH_APIS}operation/operation-security-create-cross-cluster-api-key`,
      remoteClustersOnPremPrerequisitesApiKey: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-api-key#remote-clusters-prerequisites-api-key`,
      remoteClustersOnPremSecurityApiKey: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-api-key#remote-clusters-security-api-key`,
      remoteClustersOnPremPrerequisitesCert: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-cert#remote-clusters-prerequisites-cert`,
      remoteClustersOnPremSecurityCert: `${ELASTIC_DOCS}deploy-manage/remote-clusters/remote-clusters-cert#remote-clusters-security-cert`,
      rollupMigratingToDownsampling: `${ELASTIC_DOCS}manage-data/lifecycle/rollup/migrating-from-rollup-to-downsampling`,
      rrf: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/reciprocal-rank-fusion`,
      scriptParameters: `${ELASTIC_DOCS}explore-analyze/scripting/modules-scripting-using#prefer-params`,
      secureCluster: `${ELASTIC_DOCS}deploy-manage/security`,
      shardAllocationSettings: `${ELASTIC_DOCS}reference/elasticsearch/configuration-reference/cluster-level-shard-allocation-routing-settings#cluster-shard-allocation-settings`,
      sortSearch: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/sort-search-results`,
      tutorialUpdateExistingDataStream: `${ELASTIC_DOCS}manage-data/lifecycle/data-stream/tutorial-update-existing-data-stream`,
      transportSettings: `${ELASTIC_DOCS}reference/elasticsearch/configuration-reference/networking-settings#common-network-settings`,
      typesRemoval: `${ELASTIC_DOCS}manage-data/data-store/mapping/removal-of-mapping-types`,
      setupUpgrade: `${ELASTIC_DOCS}deploy-manage/upgrade/deployment-or-cluster`,
      apiCompatibilityHeader: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/api-conventions#api-compatibility`,
      migrationGuide: `${ELASTIC_DOCS}release-notes/elasticsearch/breaking-changes`
    },
    siem: {
      guide: `${ELASTIC_DOCS}solutions/security`,
      gettingStarted: `${ELASTIC_DOCS}solutions/security`,
      privileges: `${ELASTIC_DOCS}solutions/security/get-started/elastic-security-requirements`,
      ingestDataToSecurity: `${ELASTIC_DOCS}solutions/security/get-started/ingest-data-to-elastic-security`,
      automaticImport: `${ELASTIC_DOCS}solutions/security/get-started/automatic-import`,
      ml: `${ELASTIC_DOCS}solutions/security/advanced-entity-analytics/anomaly-detection`,
      ruleChangeLog: `https://www.elastic.co/guide/en/security/current/prebuilt-rules-downloadable-updates.html`,
      detectionsReq: `${ELASTIC_DOCS}solutions/security/detect-and-alert/detections-requirements`,
      networkMap: `${ELASTIC_DOCS}solutions/security/explore/configure-network-map-data`,
      troubleshootGaps: `${ELASTIC_DOCS}troubleshoot/security/detection-rules#troubleshoot-gaps`,
      gapsTable: `${ELASTIC_DOCS}solutions/security/detect-and-alert/monitor-rule-executions#gaps-table`,
      ruleApiOverview: isServerless ? `${KIBANA_APIS}group/endpoint-security-detections-api` : `${KIBANA_SERVERLESS_APIS}group/endpoint-security-detections-api`,
      configureAlertSuppression: `${ELASTIC_DOCS}solutions/security/detect-and-alert/suppress-detection-alerts#security-alert-suppression-configure-alert-suppression`
    },
    server: {
      protocol: `${ELASTIC_DOCS}reference/kibana/configuration-reference/general-settings#server-protocol`,
      publicBaseUrl: `${ELASTIC_DOCS}reference/kibana/configuration-reference/general-settings#server-publicBaseUrl`,
      troubleshootServerNotReady: `${ELASTIC_DOCS}troubleshoot/kibana/error-server-not-ready`
    },
    logging: {
      enableDeprecationHttpDebugLogs: `${ELASTIC_DOCS}reference/kibana/configuration-reference/logging-settings#enable-http-debug-logs`
    },
    securitySolution: {
      artifactControl: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/configure-updates-for-protection-artifacts`,
      cloudSecurityPosture: `${ELASTIC_DOCS}solutions/security/cloud/cloud-security-posture-management`,
      installElasticDefend: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/install-elastic-defend`,
      avcResults: `https://www.elastic.co/blog/elastic-security-av-comparatives-business-test`,
      bidirectionalIntegrations: `${ELASTIC_DOCS}solutions/security/endpoint-response-actions/third-party-response-actions`,
      trustedApps: `${ELASTIC_DOCS}solutions/security/manage-elastic-defend/trusted-applications`,
      trustedDevices: `${ELASTIC_DOCS}solutions/security/manage-elastic-defend/trusted-devices`,
      elasticAiFeatures: `${ELASTIC_DOCS}solutions/security/ai`,
      eventFilters: `${ELASTIC_DOCS}solutions/security/manage-elastic-defend/event-filters`,
      blocklist: `${ELASTIC_DOCS}solutions/security/manage-elastic-defend/blocklist`,
      threatIntelInt: `${ELASTIC_DOCS}solutions/security/get-started/enable-threat-intelligence-integrations`,
      endpointArtifacts: `${ELASTIC_DOCS}solutions/security/manage-elastic-defend/optimize-elastic-defend`,
      eventMerging: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/configure-data-volume-for-elastic-endpoint`,
      policyResponseTroubleshooting: {
        full_disk_access: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/enable-access-for-macos-monterey#enable-fda-endpoint`,
        macos_system_ext: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/enable-access-for-macos-monterey#system-extension-endpoint`,
        linux_deadlock: `${ELASTIC_DOCS}troubleshoot/security/elastic-defend#linux-deadlock`
      },
      packageActionTroubleshooting: {
        es_connection: `${ELASTIC_DOCS}troubleshoot/security/elastic-defend`
      },
      responseActions: `${ELASTIC_DOCS}solutions/security/endpoint-response-actions`,
      configureEndpointIntegrationPolicy: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/configure-an-integration-policy-for-elastic-defend`,
      exceptions: {
        value_lists: `${ELASTIC_DOCS}solutions/security/detect-and-alert/create-manage-value-lists`
      },
      privileges: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/elastic-defend-feature-privileges`,
      manageDetectionRules: `${ELASTIC_DOCS}solutions/security/detect-and-alert/manage-detection-rules`,
      createDetectionRules: `${ELASTIC_DOCS}solutions/security/detect-and-alert/create-detection-rule`,
      updatePrebuiltDetectionRules: `${ELASTIC_DOCS}solutions/security/detect-and-alert/install-manage-elastic-prebuilt-rules#update-prebuilt-rules`,
      prebuiltRuleCustomizationPromoBlog: `${ELASTIC_WEBSITE_URL}blog/security-prebuilt-rules-editing`,
      resolvePrebuiltRuleConflicts: `${ELASTIC_DOCS}solutions/security/detect-and-alert/prebuilt-rules-update-modified-unmodified#resolve-reduce-rule-conflicts`,
      createEsqlRuleType: `${ELASTIC_DOCS}solutions/security/detect-and-alert/create-detection-rule#create-esql-rule`,
      ruleUiAdvancedParams: `${ELASTIC_DOCS}solutions/security/detect-and-alert/create-detection-rule#rule-ui-advanced-params`,
      thirdPartyLlmProviders: `${ELASTIC_DOCS}solutions/security/ai/set-up-connectors-for-large-language-models-llm`,
      entityAnalytics: {
        riskScorePrerequisites: `${ELASTIC_DOCS}solutions/security/advanced-entity-analytics/entity-risk-scoring-requirements`,
        entityRiskScoring: `${ELASTIC_DOCS}solutions/security/advanced-entity-analytics/entity-risk-scoring`,
        assetCriticality: `${ELASTIC_DOCS}solutions/security/advanced-entity-analytics/asset-criticality`,
        privilegedUserMonitoring: `${ELASTIC_DOCS}solutions/security/advanced-entity-analytics/privileged-user-monitoring`,
        mlAnomalyDetection: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection`
      },
      detectionEngineOverview: `${ELASTIC_DOCS}solutions/security/detect-and-alert`,
      aiAssistant: {
        home: `${ELASTIC_DOCS}solutions/security/ai/ai-assistant`,
        knowledgeBaseHome: `${ELASTIC_DOCS}solutions/security/ai/ai-assistant-knowledge-base`,
        knowledgeBaseIndexEntries: `${ELASTIC_DOCS}solutions/security/ai/ai-assistant-knowledge-base#knowledge-base-add-knowledge-index`
      },
      signalsMigrationApi: isServerless ? `${KIBANA_APIS}group/endpoint-security-detections-api` : `${KIBANA_SERVERLESS_APIS}group/endpoint-security-detections-api`,
      siemMigrations: `${ELASTIC_DOCS}solutions/security/get-started/automatic-migration`,
      llmPerformanceMatrix: `${ELASTIC_DOCS}solutions/security/ai/large-language-model-performance-matrix`
    },
    query: {
      eql: `${ELASTIC_DOCS}explore-analyze/query-filter/languages/eql`,
      kueryQuerySyntax: `${ELASTIC_DOCS}explore-analyze/query-filter/languages/kql`,
      luceneQuery: `${ELASTIC_DOCS}reference/query-languages/query-dsl/query-dsl-query-string-query`,
      luceneQuerySyntax: `${ELASTIC_DOCS}reference/query-languages/query-dsl/query-dsl-query-string-query#query-string-syntax`,
      percolate: `${ELASTIC_DOCS}reference/query-languages/query-dsl/query-dsl-percolate-query`,
      queryDsl: `${ELASTIC_DOCS}explore-analyze/query-filter/languages/querydsl`,
      queryESQL: `${ELASTIC_DOCS}explore-analyze/query-filter/languages/esql`,
      queryESQLExamples: `${ELASTIC_DOCS}explore-analyze/query-filter/languages/esql`,
      queryESQLMultiValueControls: `${ELASTIC_DOCS}explore-analyze/query-filter/languages/esql-kibana#esql-multi-values-controls`
    },
    search: {
      sessions: `${ELASTIC_DOCS}explore-analyze/discover/search-sessions`,
      sessionLimits: `${ELASTIC_DOCS}explore-analyze/discover/search-sessions#_limitations`
    },
    date: {
      dateMath: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/common-options#date-math`,
      dateMathIndexNames: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/api-conventions#api-date-math-index-names`
    },
    management: {
      dashboardSettings: `${ELASTIC_DOCS}reference/kibana/advanced-settings#kibana-dashboard-settings`,
      indexManagement: isServerless ? `${ELASTIC_DOCS}manage-data/data-store/index-basics` : `${ELASTIC_DOCS}manage-data/lifecycle/index-lifecycle-management/index-management-in-kibana`,
      kibanaSearchSettings: `${ELASTIC_DOCS}reference/kibana/advanced-settings#kibana-search-settings`,
      discoverSettings: `${ELASTIC_DOCS}reference/kibana/advanced-settings#kibana-discover-settings`,
      rollupSettings: `${ELASTIC_DOCS}reference/kibana/advanced-settings#kibana-rollups-settings`,
      visualizationSettings: `${ELASTIC_DOCS}reference/kibana/advanced-settings#kibana-visualization-settings`,
      timelionSettings: `${ELASTIC_DOCS}reference/kibana/advanced-settings#kibana-timelion-settings`,
      generalSettings: `${ELASTIC_DOCS}reference/kibana/advanced-settings#kibana-general-settings`,
      savedObjectsApiList: isServerless ? `${KIBANA_SERVERLESS_APIS}group/endpoint-saved-objects` : `${KIBANA_APIS}group/endpoint-saved-objects`,
      apiKeys: `${ELASTIC_DOCS}deploy-manage/api-keys/elasticsearch-api-keys`
    },
    ml: {
      guide: `${ELASTIC_DOCS}explore-analyze/machine-learning`,
      aggregations: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-configuring-aggregation`,
      anomalyDetection: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection`,
      anomalyDetectionBucketSpan: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-bucket-span`,
      anomalyDetectionConfiguringCategories: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-configuring-categories`,
      anomalyDetectionCardinality: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-cardinality`,
      anomalyDetectionCreateJobs: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-create-job`,
      anomalyDetectionDetectors: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-detectors`,
      anomalyDetectionFunctions: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-functions`,
      anomalyDetectionInfluencers: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-influencers`,
      anomalyDetectionJobs: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-finding-anomalies`,
      anomalyDetectionJobResource: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-ml-put-job` : `${ELASTICSEARCH_APIS}operation/operation-ml-put-job`,
      anomalyDetectionJobResourceAnalysisConfig: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-ml-put-job` : `${ELASTICSEARCH_APIS}operation/operation-ml-put-job`,
      anomalyDetectionJobTips: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs`,
      anomalyDetectionScoreExplanation: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-explain`,
      alertingRules: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-configuring-alerts`,
      anomalyDetectionModelMemoryLimits: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-model-memory-limits`,
      calendars: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-calendars`,
      classificationEvaluation: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-dfa-classification#ml-dfanalytics-classification-evaluation`,
      customRules: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-ad-run-jobs#ml-ad-rules`,
      customUrls: `${ELASTIC_DOCS}explore-analyze/machine-learning/anomaly-detection/ml-configuring-url`,
      dataFrameAnalytics: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics`,
      dFAPrepareData: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-dfa-overview#prepare-transform-data`,
      dFAStartJob: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-ml-start-data-frame-analytics` : `${ELASTICSEARCH_APIS}operation/operation-ml-start-data-frame-analytics`,
      dFACreateJob: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-ml-put-data-frame-analytics` : `${ELASTICSEARCH_APIS}operation/operation-ml-put-data-frame-analytics`,
      featureImportance: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-feature-importance`,
      outlierDetectionRoc: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-dfa-finding-outliers#ml-dfanalytics-roc`,
      regressionEvaluation: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-dfa-regression#ml-dfanalytics-regression-evaluation`,
      classificationAucRoc: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-dfa-classification#ml-dfanalytics-class-aucroc`,
      setUpgradeMode: `${ELASTICSEARCH_APIS}operation/operation-ml-set-upgrade-mode`,
      trainedModels: `${ELASTIC_DOCS}explore-analyze/machine-learning/data-frame-analytics/ml-trained-models`,
      startTrainedModelsDeployment: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-deploy-model`,
      logsAnomalyDetectionConfigs: `${ELASTIC_DOCS}reference/data-analysis/machine-learning/ootb-ml-jobs-logs-ui`,
      metricsAnomalyDetectionConfigs: `${ELASTIC_DOCS}reference/data-analysis/machine-learning/ootb-ml-jobs-metrics-ui`,
      nlpElser: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-elser`,
      nlpE5: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-e5`,
      nlpImportModel: `${ELASTIC_DOCS}explore-analyze/machine-learning/nlp/ml-nlp-import-model`
    },
    transforms: {
      guide: `${ELASTIC_DOCS}explore-analyze/transforms`,
      alertingRules: `${ELASTIC_DOCS}explore-analyze/transforms/transform-alerts`,
      overview: `${ELASTIC_DOCS}explore-analyze/transforms/transform-overview`
    },
    visualize: {
      guide: `${ELASTIC_DOCS}explore-analyze/visualize`,
      lens: `${ELASTIC_WEBSITE_URL}what-is/kibana-lens`,
      lensPanels: `${ELASTIC_DOCS}explore-analyze/visualize/lens`,
      maps: `${ELASTIC_WEBSITE_URL}maps`,
      vega: `${ELASTIC_DOCS}explore-analyze/visualize/custom-visualizations-with-vega`,
      tsvbIndexPatternMode: `${ELASTIC_DOCS}explore-analyze/visualize/legacy-editors/tsvb#tsvb-data-view-mode`
    },
    observability: {
      guide: `${ELASTIC_DOCS}solutions/observability`,
      infrastructureThreshold: `${ELASTIC_DOCS}solutions/observability/incident-management/create-an-inventory-rule`,
      logsThreshold: `${ELASTIC_DOCS}solutions/observability/incident-management/create-log-threshold-rule`,
      metricsThreshold: `${ELASTIC_DOCS}solutions/observability/incident-management/create-metric-threshold-rule`,
      customThreshold: `${ELASTIC_DOCS}solutions/observability/incident-management/create-custom-threshold-rule`,
      monitorStatus: `${ELASTIC_DOCS}solutions/observability/incident-management/create-monitor-status-rule`,
      monitorUptime: `${ELASTIC_DOCS}solutions/observability/synthetics`,
      tlsCertificate: `${ELASTIC_DOCS}solutions/observability/incident-management/create-tls-certificate-rule`,
      uptimeDurationAnomaly: `${ELASTIC_DOCS}solutions/observability/incident-management/create-an-uptime-duration-anomaly-rule`,
      monitorLogs: `${ELASTIC_DOCS}solutions/observability/logs/explore-logs`,
      logsStreams: `${ELASTIC_DOCS}solutions/observability/streams/streams`,
      wiredStreams: `${ELASTIC_DOCS}solutions/observability/streams/wired-streams`,
      analyzeMetrics: `${ELASTIC_DOCS}solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics`,
      monitorUptimeSynthetics: `${ELASTIC_DOCS}solutions/observability/synthetics`,
      userExperience: `${ELASTIC_DOCS}solutions/observability/applications/user-experience`,
      createAlerts: `${ELASTIC_DOCS}solutions/observability/incident-management/alerting`,
      syntheticsAlerting: `${ELASTIC_DOCS}solutions/observability/synthetics/configure-settings#synthetics-settings-alerting`,
      syntheticsCommandReference: `${ELASTIC_DOCS}solutions/observability/synthetics/configure-projects#synthetics-configuration-playwright-options`,
      syntheticsProjectMonitors: `${ELASTIC_DOCS}solutions/observability/synthetics/create-monitors-with-projects`,
      syntheticsMigrateFromIntegration: `${ELASTIC_DOCS}solutions/observability/synthetics/migrate-from-elastic-synthetics-integration`,
      slo: `${ELASTIC_DOCS}solutions/observability/incident-management/service-level-objectives-slos`,
      sloBurnRateRule: `${ELASTIC_DOCS}solutions/observability/incident-management/create-an-slo-burn-rate-rule`,
      aiAssistant: `${ELASTIC_DOCS}solutions/observability/observability-ai-assistant`,
      elasticManagedLlm: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/elastic-managed-llm`,
      elasticManagedLlmUsageCost: `${ELASTIC_WEBSITE_URL}pricing`,
      elasticServerlessSearchManagedLlmUsageCost: `${ELASTIC_WEBSITE_URL}pricing/serverless-search`
    },
    alerting: {
      guide: `${ELASTIC_DOCS}explore-analyze/alerts-cases/alerts/create-manage-rules`,
      actionTypes: `${ELASTIC_DOCS}reference/kibana/connectors-kibana`,
      apmRulesErrorCount: `${ELASTIC_DOCS}solutions/observability/incident-management/create-an-error-count-threshold-rule`,
      apmRulesTransactionDuration: `${ELASTIC_DOCS}solutions/observability/incident-management/create-latency-threshold-rule`,
      apmRulesTransactionError: `${ELASTIC_DOCS}solutions/observability/incident-management/create-failed-transaction-rate-threshold-rule`,
      apmRulesAnomaly: `${ELASTIC_DOCS}solutions/observability/incident-management/create-an-apm-anomaly-rule`,
      authorization: `${KIBANA_DOCS}alerting-setup.html#alerting-authorization`,
      emailAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/email-action-type`,
      emailActionConfig: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/email-action-type`,
      emailExchangeClientSecretConfig: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/email-action-type#exchange-client-secret`,
      emailExchangeClientIdConfig: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/email-action-type#exchange-client-tenant-id`,
      generalSettings: `${ELASTIC_DOCS}reference/kibana/configuration-reference/alerting-settings#general-alert-action-settings`,
      indexAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/index-action-type`,
      esQuery: `${ELASTIC_DOCS}explore-analyze/alerts-cases/alerts/rule-type-es-query`,
      indexThreshold: `${ELASTIC_DOCS}explore-analyze/alerts-cases/alerts/rule-type-index-threshold`,
      maintenanceWindows: `${ELASTIC_DOCS}explore-analyze/alerts-cases/alerts/maintenance-windows`,
      pagerDutyAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/pagerduty-action-type`,
      preconfiguredConnectors: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/pre-configured-connectors`,
      preconfiguredAlertHistoryConnector: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/pre-configured-connectors#preconfigured-connector-alert-history`,
      serviceNowAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/servicenow-action-type#configuring-servicenow`,
      serviceNowSIRAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/servicenow-sir-action-type`,
      setupPrerequisites: `${ELASTIC_DOCS}explore-analyze/alerts-cases/alerts/alerting-setup#alerting-prerequisites`,
      slackAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/slack-action-type#configuring-slack-webhook`,
      slackApiAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/slack-action-type#configuring-slack-web-api`,
      teamsAction: `${ELASTIC_DOCS}reference/kibana/connectors-kibana/teams-action-type#configuring-teams`,
      connectors: `${ELASTIC_DOCS}reference/kibana/connectors-kibana`
    },
    taskManager: {
      healthMonitoring: `${ELASTIC_DOCS}deploy-manage/monitor/kibana-task-manager-health-monitoring`
    },
    maps: {
      connectToEms: `${ELASTIC_DOCS}explore-analyze/visualize/maps/maps-connect-to-ems`,
      guide: `${ELASTIC_DOCS}explore-analyze/visualize/maps`,
      importGeospatialPrivileges: `${ELASTIC_DOCS}explore-analyze/visualize/maps/import-geospatial-data#import-geospatial-privileges`,
      gdalTutorial: `${ELASTIC_WEBSITE_URL}blog/how-to-ingest-geospatial-data-into-elasticsearch-with-gdal`,
      termJoinsExample: `${ELASTIC_DOCS}explore-analyze/visualize/maps/terms-join#_example_term_join`
    },
    monitoring: {
      alertsKibana: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts`,
      alertsKibanaCpuThreshold: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-cpu-threshold`,
      alertsKibanaDiskThreshold: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-disk-usage-threshold`,
      alertsKibanaJvmThreshold: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-jvm-memory-threshold`,
      alertsKibanaMissingData: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-missing-monitoring-data`,
      alertsKibanaThreadpoolRejections: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-thread-pool-rejections`,
      alertsKibanaCCRReadExceptions: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-ccr-read-exceptions`,
      alertsKibanaLargeShardSize: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-large-shard-size`,
      alertsKibanaClusterAlerts: `${ELASTIC_DOCS}deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts#kibana-alerts-cluster-alerts`,
      metricbeatBlog: `https://www.elastic.co/blog/external-collection-for-elastic-stack-monitoring-is-now-available-via-metricbeat`,
      monitorElasticsearch: `${ELASTIC_DOCS}deploy-manage/monitor/stack-monitoring/collecting-monitoring-data-with-metricbeat`,
      monitorKibana: `${ELASTIC_DOCS}deploy-manage/monitor/stack-monitoring/kibana-monitoring-metricbeat`,
      monitorLogstash: `${ELASTIC_DOCS}reference/logstash/monitoring-with-metricbeat`,
      troubleshootKibana: `${ELASTIC_DOCS}troubleshoot/kibana/monitoring`
    },
    reporting: {
      cloudMinimumRequirements: `${ELASTIC_DOCS}explore-analyze/report-and-share#_embed_outside_of_kib`,
      browserSystemDependencies: `${ELASTIC_DOCS}deploy-manage/kibana-reporting-configuration#install-reporting-packages`,
      browserSandboxDependencies: `${ELASTIC_DOCS}explore-analyze/report-and-share/reporting-troubleshooting-pdf#reporting-troubleshooting-sandbox-dependency`
    },
    security: {
      apiKeyServiceSettings: `${ELASTIC_DOCS}reference/elasticsearch/configuration-reference/security-settings#api-key-service-settings`,
      clusterPrivileges: `${ELASTIC_DOCS}reference/elasticsearch/security-privileges#privileges-list-cluster`,
      definingRoles: `${ELASTIC_DOCS}deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles`,
      elasticsearchSettings: `${ELASTIC_DOCS}reference/elasticsearch/configuration-reference/security-settings`,
      elasticsearchEnableSecurity: `${ELASTIC_DOCS}deploy-manage/deploy/self-managed/installing-elasticsearch`,
      elasticsearchEnableApiKeys: `${ELASTIC_DOCS}reference/elasticsearch/configuration-reference/security-settings#api-key-service-settings`,
      indicesPrivileges: `${ELASTIC_DOCS}reference/elasticsearch/security-privileges#privileges-list-indices`,
      kibanaTLS: `${ELASTIC_DOCS}deploy-manage/security/set-up-basic-security#encrypt-internode-communication`,
      kibanaPrivileges: `${ELASTIC_DOCS}deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges`,
      mappingRoles: `${ELASTIC_DOCS}deploy-manage/users-roles/cluster-or-deployment-auth/mapping-users-groups-to-roles`,
      mappingRolesFieldRules: `${ELASTIC_DOCS}deploy-manage/users-roles/cluster-or-deployment-auth/role-mapping-resources#mapping-roles-rule-field`,
      roles: `${ELASTIC_DOCS}reference/elasticsearch/roles`,
      runAsPrivilege: `${ELASTIC_DOCS}reference/elasticsearch/security-privileges#_run_as_privilege`,
      enableElasticSearchSecurityFeatures: `${ELASTIC_DOCS}deploy-manage/security/set-up-minimal-security#_enable_es_security_features`
    },
    spaces: {
      kibanaLegacyUrlAliases: `${ELASTIC_DOCS}extend/kibana/legacy-url-aliases`,
      kibanaDisableLegacyUrlAliasesApi: `${KIBANA_APIS}operation/operation-post-spaces-disable-legacy-url-aliases`,
      kibanaManageSpaces: `${ELASTIC_DOCS}deploy-manage/manage-spaces`
    },
    watcher: {
      jiraAction: `${ELASTIC_DOCS}explore-analyze/alerts-cases/watcher/actions-jira`,
      pagerDutyAction: `${ELASTIC_DOCS}explore-analyze/alerts-cases/watcher/actions-pagerduty`,
      slackAction: `${ELASTIC_DOCS}explore-analyze/alerts-cases/watcher/actions-slack`,
      ui: `${ELASTIC_DOCS}explore-analyze/alerts-cases/watcher`
    },
    ccs: {
      guide: `${ELASTIC_DOCS}solutions/search/cross-cluster-search`,
      skippingDisconnectedClusters: `${ELASTIC_DOCS}solutions/search/cross-cluster-search#skip-unavailable-clusters`
    },
    apis: {
      bulkIndexAlias: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-indices-update-aliases` : `${ELASTICSEARCH_APIS}operation/operation-indices-update-aliases`,
      indexStats: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-indices-update-aliases` : `${ELASTICSEARCH_APIS}operation/operation-indices-stats`,
      byteSizeUnits: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/api-conventions#byte-units`,
      createAutoFollowPattern: `${ELASTICSEARCH_APIS}operation/operation-ccr-put-auto-follow-pattern`,
      createFollower: `${ELASTICSEARCH_APIS}operation/operation-ccr-follow`,
      createIndex: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-indices-create` : `${ELASTICSEARCH_APIS}operation/operation-indices-create`,
      createSnapshotLifecyclePolicy: `${ELASTICSEARCH_APIS}operation/operation-slm-put-lifecycle`,
      createRoleMapping: `${ELASTICSEARCH_APIS}operation/operation-security-put-role-mapping`,
      createRoleMappingTemplates: `${ELASTICSEARCH_APIS}operation/operation-security-put-role-mapping`,
      createRollupJobsRequest: `${ELASTICSEARCH_APIS}operation/operation-rollup-put-job#operation-rollup-put-job-body-application-json`,
      createApiKey: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-security-create-api-key` : `${ELASTICSEARCH_APIS}operation/operation-security-create-api-key`,
      createApiKeyMetadata: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-security-create-api-key#operation-security-create-api-key-body-application-json` : `${ELASTICSEARCH_APIS}operation/operation-security-create-api-key#operation-security-create-api-key-body-application-json`,
      createApiKeyRoleDescriptors: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-security-create-api-key#operation-security-create-api-key-body-application-json-role_descriptors` : `${ELASTICSEARCH_APIS}operation/operation-security-create-api-key#operation-security-create-api-key-body-application-json-role_descriptors`,
      createCrossClusterApiKey: `${ELASTICSEARCH_APIS}operation/operation-security-create-cross-cluster-api-key`,
      createPipeline: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-ingest-put-pipeline` : `${ELASTICSEARCH_APIS}operation/operation-ingest-put-pipeline`,
      createTransformRequest: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-transform-put-transform` : `${ELASTICSEARCH_APIS}operation/operation-transform-put-transform`,
      cronExpressions: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/api-conventions#api-cron-expressions`,
      executeWatchActionModes: `${ELASTICSEARCH_APIS}operation/operation-watcher-execute-watch#operation-watcher-execute-watch-body-application-json`,
      indexExists: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-indices-exists` : `${ELASTICSEARCH_APIS}operation/operation-indices-exists`,
      inferTrainedModel: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-ml-infer-trained-model` : `${ELASTICSEARCH_APIS}operation/operation-ml-infer-trained-model`,
      multiSearch: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-msearch` : `${ELASTICSEARCH_APIS}operation/operation-msearch`,
      openIndex: `${ELASTICSEARCH_APIS}operation/operation-indices-open`,
      putComponentTemplate: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-cluster-put-component-template` : `${ELASTICSEARCH_APIS}operation/operation-cluster-put-component-template`,
      painlessExecute: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-scripts-painless-execute` : `${ELASTICSEARCH_APIS}operation/operation-scripts-painless-execute`,
      painlessExecuteAPIContexts: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-scripts-painless-execute#operation-scripts-painless-execute-body-application-json` : `${ELASTICSEARCH_APIS}operation/operation-scripts-painless-execute#operation-scripts-painless-execute-body-application-json`,
      putComponentTemplateMetadata: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-cluster-put-component-template#operation-cluster-put-component-template-body-application-json-_meta` : `${ELASTICSEARCH_APIS}operation/operation-cluster-put-component-template#operation-cluster-put-component-template-body-application-json-_meta`,
      putEnrichPolicy: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-enrich-put-policy` : `${ELASTICSEARCH_APIS}operation/operation-enrich-put-policy`,
      putIndexTemplateV1: `${ELASTICSEARCH_APIS}operation/operation-indices-put-template`,
      putSnapshotLifecyclePolicy: `${ELASTICSEARCH_APIS}operation/operation-slm-put-lifecycle`,
      putWatch: `${ELASTICSEARCH_APIS}operation/operation-watcher-put-watch`,
      restApis: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}` : `${ELASTICSEARCH_APIS}`,
      searchPreference: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-search#operation-search-preference` : `${ELASTICSEARCH_APIS}operation/operation-search#operation-search-preference`,
      securityApis: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}group/endpoint-security` : `${ELASTICSEARCH_APIS}group/endpoint-security`,
      simulatePipeline: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-ingest-simulate` : `${ELASTICSEARCH_APIS}operation/operation-ingest-simulate`,
      tasks: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}group/endpoint-tasks` : `${ELASTICSEARCH_APIS}group/endpoint-tasks`,
      timeUnits: `${ELASTIC_DOCS}reference/elasticsearch/rest-apis/api-conventions#time-units`,
      updateTransform: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-transform-update-transform` : `${ELASTICSEARCH_APIS}operation/operation-transform-update-transform`
    },
    plugins: {
      azureRepo: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/azure-repository`,
      gcsRepo: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/google-cloud-storage-repository`,
      hdfsRepo: `${ELASTIC_DOCS}reference/elasticsearch/plugins/repository-hdfs`,
      ingestAttachment: `${ELASTIC_DOCS}reference/enrich-processor/attachment`,
      s3Repo: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/s3-repository`,
      snapshotRestoreRepos: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/self-managed`,
      mapperSize: `${ELASTIC_DOCS}reference/elasticsearch/plugins/mapper-size-usage`
    },
    snapshotRestore: {
      guide: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore`,
      changeIndexSettings: `${ELASTIC_DOCS}reference/elasticsearch/index-settings/index-modules`,
      createSnapshot: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/create-snapshots`,
      getSnapshot: `${ELASTICSEARCH_APIS}operation/operation-snapshot-get`,
      registerSharedFileSystem: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/shared-file-system-repository#filesystem-repository-settings`,
      registerSourceOnly: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/source-only-repository#source-only-repository-settings`,
      registerUrl: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/read-only-url-repository#read-only-url-repository-settings`,
      restoreSnapshot: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/restore-snapshot`,
      restoreSnapshotApi: `${ELASTICSEARCH_APIS}operation/operation-snapshot-restore`,
      searchableSnapshotSharedCache: `${ELASTIC_DOCS}deploy-manage/tools/snapshot-and-restore/searchable-snapshots#searchable-snapshots-shared-cache`,
      slmStart: `${ELASTICSEARCH_APIS}operation/operation-slm-start`
    },
    ingest: {
      append: `${ELASTIC_DOCS}reference/enrich-processor/append-processor`,
      bytes: `${ELASTIC_DOCS}reference/enrich-processor/bytes-processor`,
      circle: `${ELASTIC_DOCS}reference/enrich-processor/ingest-circle-processor`,
      community: `${ELASTIC_DOCS}reference/enrich-processor/community-id-processor`,
      convert: `${ELASTIC_DOCS}reference/enrich-processor/convert-processor`,
      csv: `${ELASTIC_DOCS}reference/enrich-processor/csv-processor`,
      date: `${ELASTIC_DOCS}reference/enrich-processor/date-processor`,
      dateIndexName: `${ELASTIC_DOCS}reference/enrich-processor/date-index-name-processor`,
      dissect: `${ELASTIC_DOCS}reference/enrich-processor/dissect-processor`,
      dissectKeyModifiers: `${ELASTIC_DOCS}reference/enrich-processor/dissect-processor#dissect-key-modifiers`,
      dotExpander: `${ELASTIC_DOCS}reference/enrich-processor/dot-expand-processor`,
      drop: `${ELASTIC_DOCS}reference/enrich-processor/drop-processor`,
      enrich: `${ELASTIC_DOCS}manage-data/ingest/transform-enrich/data-enrichment`,
      fail: `${ELASTIC_DOCS}reference/enrich-processor/fail-processor`,
      foreach: `${ELASTIC_DOCS}reference/enrich-processor/foreach-processor`,
      geoGrid: `${ELASTIC_DOCS}reference/enrich-processor/ingest-geo-grid-processor`,
      geoIp: `${ELASTIC_DOCS}reference/enrich-processor/geoip-processor`,
      geoMatch: `${ELASTIC_DOCS}manage-data/ingest/transform-enrich/example-enrich-data-based-on-geolocation`,
      grok: `${ELASTIC_DOCS}reference/enrich-processor/grok-processor`,
      gsub: `${ELASTIC_DOCS}reference/enrich-processor/gsub-processor`,
      htmlString: `${ELASTIC_DOCS}reference/enrich-processor/htmlstrip-processor`,
      inference: `${ELASTIC_DOCS}reference/enrich-processor/inference-processor`,
      inferenceClassification: `${ELASTIC_DOCS}reference/enrich-processor/inference-processor#inference-processor-classification-opt`,
      inferenceRegression: `${ELASTIC_DOCS}reference/enrich-processor/inference-processor#inference-processor-regression-opt`,
      ipLocation: `${ELASTIC_DOCS}reference/enrich-processor/ip-location-processor`,
      join: `${ELASTIC_DOCS}reference/enrich-processor/join-processor`,
      json: `${ELASTIC_DOCS}reference/enrich-processor/json-processor`,
      kv: `${ELASTIC_DOCS}reference/enrich-processor/kv-processor`,
      lowercase: `${ELASTIC_DOCS}reference/enrich-processor/lowercase-processor`,
      network: `${ELASTIC_DOCS}reference/enrich-processor/network-direction-processor`,
      pipeline: `${ELASTIC_DOCS}reference/enrich-processor/pipeline-processor`,
      pipelines: `${ELASTIC_DOCS}manage-data/ingest/transform-enrich/readable-maintainable-ingest-pipelines`,
      pipelineCreate: `${ELASTIC_DOCS}manage-data/ingest/transform-enrich/readable-maintainable-ingest-pipelines`,
      csvPipelines: `${ELASTIC_DOCS}reference/ecs/ecs-converting`,
      pipelineFailure: `${ELASTIC_DOCS}manage-data/ingest/transform-enrich/error-handling`,
      conditionalProcessor: `${ELASTIC_DOCS}manage-data/ingest/transform-enrich/ingest-pipelines#conditionally-run-processor`,
      processors: `${ELASTIC_DOCS}reference/enrich-processor`,
      arrayOrJson: `${ELASTIC_DOCS}reference/enrich-processor#ingest-process-category-array-json-handling`,
      dataEnrichment: `${ELASTIC_DOCS}reference/enrich-processor#ingest-process-category-data-enrichment`,
      dataFiltering: `${ELASTIC_DOCS}reference/enrich-processor#ingest-process-category-data-filtering`,
      dataTransformation: `${ELASTIC_DOCS}reference/enrich-processor#ingest-process-category-data-transformation`,
      pipelineHandling: `${ELASTIC_DOCS}reference/enrich-processor#ingest-process-category-pipeline-handling`,
      redact: `${ELASTIC_DOCS}reference/enrich-processor/redact-processor`,
      registeredDomain: `${ELASTIC_DOCS}reference/enrich-processor/registered-domain-processor`,
      remove: `${ELASTIC_DOCS}reference/enrich-processor/remove-processor`,
      rename: `${ELASTIC_DOCS}reference/enrich-processor/rename-processor`,
      reroute: `${ELASTIC_DOCS}reference/enrich-processor/reroute-processor`,
      script: `${ELASTIC_DOCS}reference/enrich-processor/script-processor`,
      set: `${ELASTIC_DOCS}reference/enrich-processor/set-processor`,
      setSecurityUser: `${ELASTIC_DOCS}reference/enrich-processor/ingest-node-set-security-user-processor`,
      sort: `${ELASTIC_DOCS}reference/enrich-processor/sort-processor`,
      split: `${ELASTIC_DOCS}reference/enrich-processor/split-processor`,
      terminate: `${ELASTIC_DOCS}reference/enrich-processor/terminate-processor`,
      trim: `${ELASTIC_DOCS}reference/enrich-processor/trim-processor`,
      uppercase: `${ELASTIC_DOCS}reference/enrich-processor/uppercase-processor`,
      uriParts: `${ELASTIC_DOCS}reference/enrich-processor/uri-parts-processor`,
      urlDecode: `${ELASTIC_DOCS}reference/enrich-processor/urldecode-processor`,
      userAgent: `${ELASTIC_DOCS}reference/enrich-processor/user-agent-processor`
    },
    fleet: {
      guide: `${ELASTIC_DOCS}reference/fleet`,
      fingerprint: `${ELASTIC_DOCS}reference/fleet/fingerprint-processor`,
      fleetServer: `${ELASTIC_DOCS}reference/fleet/fleet-server`,
      fleetServerAddFleetServer: `${ELASTIC_DOCS}reference/fleet/deployment-models`,
      settings: `${ELASTIC_DOCS}reference/fleet/fleet-settings`,
      kafkaSettings: `${ELASTIC_DOCS}reference/fleet/kafka-output-settings`,
      kafkaOutputTopicsSettings: `${ELASTIC_DOCS}reference/fleet/kafka-output-settings#_topics_settings`,
      logstashSettings: `${ELASTIC_DOCS}reference/fleet/ls-output-settings`,
      esSettings: `${ELASTIC_DOCS}reference/fleet/es-output-settings`,
      settingsFleetServerHostSettings: `${ELASTIC_DOCS}reference/fleet/fleet-settings#fleet-server-hosts-setting`,
      settingsFleetServerProxySettings: `${ELASTIC_DOCS}reference/kibana/configuration-reference/fleet-settings#fleet-data-visualizer-settings`,
      troubleshooting: `${ELASTIC_DOCS}troubleshoot/ingest/fleet/common-problems`,
      elasticAgent: `${ELASTIC_DOCS}reference/fleet/install-elastic-agents`,
      beatsAgentComparison: `${ELASTIC_DOCS}manage-data/ingest/tools`,
      datastreams: `${ELASTIC_DOCS}reference/fleet/data-streams`,
      datastreamsILM: `${ELASTIC_DOCS}reference/fleet/data-streams#data-streams-ilm`,
      datastreamsNamingScheme: `${ELASTIC_DOCS}reference/fleet/data-streams#data-streams-naming-scheme`,
      datastreamsManualRollover: `${ELASTIC_DOCS}manage-data/data-store/data-streams/use-data-stream#manually-roll-over-a-data-stream`,
      datastreamsTSDS: `${ELASTIC_DOCS}manage-data/data-store/data-streams/time-series-data-stream-tsds`,
      datastreamsTSDSMetrics: `${ELASTIC_DOCS}manage-data/data-store/data-streams/time-series-data-stream-tsds#time-series-metric`,
      datastreamsDownsampling: `${ELASTIC_DOCS}manage-data/data-store/data-streams/downsampling-time-series-data-stream`,
      installElasticAgent: `${ELASTIC_DOCS}reference/fleet/install-fleet-managed-elastic-agent`,
      installElasticAgentStandalone: `${ELASTIC_DOCS}reference/fleet/install-standalone-elastic-agent`,
      grantESAccessToStandaloneAgents: `${ELASTIC_DOCS}reference/fleet/grant-access-to-elasticsearch`,
      upgradeElasticAgent: `${ELASTIC_DOCS}reference/fleet/upgrade-elastic-agent`,
      learnMoreBlog: `https://www.elastic.co/blog/elastic-agent-and-fleet-make-it-easier-to-integrate-your-systems-with-elastic`,
      apiKeysLearnMore: isServerless ? `${ELASTIC_DOCS}deploy-manage/api-keys/serverless-project-api-keys` : `${ELASTIC_DOCS}deploy-manage/api-keys/elasticsearch-api-keys`,
      onPremRegistry: `${ELASTIC_DOCS}reference/fleet/air-gapped`,
      packageSignatures: `${ELASTIC_DOCS}reference/fleet/package-signatures`,
      secureLogstash: `${ELASTIC_DOCS}reference/fleet/secure-logstash-connections`,
      agentPolicy: `${ELASTIC_DOCS}reference/fleet/agent-policy`,
      agentlessIntegrations: `${ELASTIC_DOCS}solutions/security/get-started/agentless-integrations`,
      api: `${ELASTIC_DOCS}reference/fleet/fleet-api-docs`,
      uninstallAgent: `${ELASTIC_DOCS}solutions/security/configure-elastic-defend/uninstall-elastic-agent`,
      installAndUninstallIntegrationAssets: `${ELASTIC_DOCS}reference/fleet/install-uninstall-integration-assets`,
      elasticAgentInputConfiguration: `${ELASTIC_DOCS}reference/fleet/elastic-agent-input-configuration`,
      policySecrets: `${ELASTIC_DOCS}reference/fleet/agent-policy#agent-policy-secret-values`,
      remoteESOoutput: `${ELASTIC_DOCS}reference/fleet/remote-elasticsearch-output`,
      performancePresets: `${ELASTIC_DOCS}reference/fleet/es-output-settings#es-output-settings-performance-tuning-settings`,
      scalingKubernetesResourcesAndLimits: `${ELASTIC_DOCS}reference/fleet/scaling-on-kubernetes#_specifying_resources_and_limits_in_agent_manifests`,
      roleAndPrivileges: `${ELASTIC_DOCS}reference/fleet/fleet-roles-privileges`,
      proxiesSettings: `${ELASTIC_DOCS}reference/fleet/fleet-agent-proxy-support`,
      unprivilegedMode: `${ELASTIC_DOCS}reference/fleet/elastic-agent-unprivileged#unprivileged-change-mode`,
      httpMonitoring: `${ELASTIC_DOCS}reference/fleet/agent-policy#change-policy-enable-agent-monitoring`,
      agentLevelLogging: `${ELASTIC_DOCS}reference/fleet/monitor-elastic-agent#change-logging-level`,
      remoteESOoutputTroubleshooting: `${ELASTIC_DOCS}reference/fleet/remote-elasticsearch-output#troubleshooting`,
      agentReleaseProcess: `${ELASTIC_DOCS}reference/fleet/fleet-agent-release-process`,
      fipsIngest: `${ELASTIC_DOCS}deploy-manage/security/fips-ingest`,
      edotCollector: `${ELASTIC_DOCS}reference/edot-collector`
    },
    integrationDeveloper: {
      upload: `${ELASTIC_DOCS}extend/integrations/upload-new-integration`
    },
    ecs: {
      guide: `${ELASTIC_DOCS}reference/ecs`,
      dataStreams: `${ELASTIC_DOCS}reference/ecs/ecs-data_stream`
    },
    clients: {
      /** Changes to these URLs must also be synched in src/platform/plugins/shared/custom_integrations/server/language_clients/index.ts */
      guide: `${ELASTIC_DOCS}reference/elasticsearch-clients`,
      goConnecting: `${ELASTIC_DOCS}reference/elasticsearch/clients/go/connecting`,
      goGettingStarted: `${ELASTIC_DOCS}reference/elasticsearch/clients/go/getting-started`,
      goIndex: `${ELASTIC_DOCS}reference/elasticsearch/clients/go`,
      goOverview: `${ELASTIC_DOCS}reference/elasticsearch/clients/go`,
      javaBasicAuthentication: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/8.18/_basic_authentication.html`,
      javaIndex: `${ELASTIC_DOCS}reference/elasticsearch/clients/java`,
      javaInstallation: `${ELASTIC_DOCS}reference/elasticsearch/clients/java/installation`,
      javaIntroduction: `${ELASTIC_DOCS}reference/elasticsearch/clients/java`,
      javaRestLow: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/8.18/java-rest-low.html`,
      jsAdvancedConfig: `${ELASTIC_DOCS}reference/elasticsearch/clients/javascript/advanced-config`,
      jsApiReference: `${ELASTIC_DOCS}reference/elasticsearch/clients/javascript/api-reference`,
      jsBasicConfig: `${ELASTIC_DOCS}reference/elasticsearch/clients/javascript/basic-config`,
      jsClientConnecting: `${ELASTIC_DOCS}reference/elasticsearch/clients/javascript/connecting`,
      jsIntro: `${ELASTIC_DOCS}reference/elasticsearch/clients/javascript`,
      netGuide: `${ELASTIC_DOCS}reference/elasticsearch/clients/dotnet`,
      netIntroduction: `${ELASTIC_DOCS}reference/elasticsearch/clients/dotnet`,
      netNest: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/7.17/nest.html`,
      netSingleNode: `${ELASTIC_DOCS}reference/elasticsearch/clients/dotnet/connecting#single-node`,
      phpConfiguration: `${ELASTIC_DOCS}reference/elasticsearch/clients/php/configuration`,
      phpConnecting: `${ELASTIC_DOCS}reference/elasticsearch/clients/php/connecting`,
      phpInstallation: `${ELASTIC_DOCS}reference/elasticsearch/clients/php/installation`,
      phpGuide: `${ELASTIC_DOCS}reference/elasticsearch/clients/php`,
      phpOverview: `${ELASTIC_DOCS}reference/elasticsearch/clients/php`,
      pythonAuthentication: `${ELASTIC_DOCS}reference/elasticsearch/clients/python/connecting#authentication`,
      pythonConfig: `${ELASTIC_DOCS}reference/elasticsearch/clients/python/configuration`,
      pythonConnecting: `${ELASTIC_DOCS}reference/elasticsearch/clients/python/connecting`,
      pythonGuide: `${ELASTIC_DOCS}reference/elasticsearch/clients/python`,
      pythonOverview: `${ELASTIC_DOCS}reference/elasticsearch/clients/python`,
      rubyAuthentication: `${ELASTIC_DOCS}reference/elasticsearch/clients/ruby/connecting#client-auth`,
      rubyAdvancedConfig: `${ELASTIC_DOCS}reference/elasticsearch/clients/ruby/advanced-config`,
      rubyBasicConfig: `${ELASTIC_DOCS}reference/elasticsearch/clients/ruby/basic-config`,
      rubyExamples: `${ELASTIC_DOCS}reference/elasticsearch/clients/ruby/examples`,
      rubyOverview: `${ELASTIC_DOCS}reference/elasticsearch/clients/ruby`,
      rustGuide: `${ELASTIC_DOCS}reference/elasticsearch/clients/rust`,
      rustOverview: `${ELASTIC_DOCS}reference/elasticsearch/clients/rust`,
      eland: `${ELASTIC_DOCS}reference/elasticsearch/clients/eland`
    },
    endpoints: {
      troubleshooting: `${SECURITY_SOLUTION_DOCS}ts-management.html#ts-endpoints`
    },
    legal: {
      privacyStatement: `${ELASTIC_WEBSITE_URL}legal/product-privacy-statement`,
      generalPrivacyStatement: `${ELASTIC_WEBSITE_URL}legal/privacy-statement`,
      termsOfService: `${ELASTIC_WEBSITE_URL}legal/elastic-cloud-account-terms`,
      dataUse: `${ELASTIC_WEBSITE_URL}legal/privacy-statement#how-we-use-the-information`
    },
    kibanaUpgradeSavedObjects: {
      resolveMigrationFailures: `${ELASTIC_DOCS}troubleshoot/kibana/migration-failures`,
      repeatedTimeoutRequests: `${ELASTIC_DOCS}troubleshoot/kibana/migration-failures#_repeated_time_out_requests_that_eventually_fail`,
      routingAllocationDisabled: `${ELASTIC_DOCS}troubleshoot/kibana/migration-failures#routing-allocation-disabled`,
      clusterShardLimitExceeded: `${ELASTIC_DOCS}troubleshoot/kibana/migration-failures#cluster-shard-limit-exceeded`
    },
    searchUI: {
      appSearch: `${ELASTIC_DOCS}reference/search-ui/tutorials-app-search`,
      elasticsearch: `${ELASTIC_DOCS}reference/search-ui/tutorials-elasticsearch`
    },
    serverlessClients: {
      clientLib: `${ELASTIC_DOCS}reference/elasticsearch-clients`,
      goApiReference: `${ELASTIC_DOCS}reference/elasticsearch/clients/go/getting-started`,
      goGettingStarted: `${ELASTIC_DOCS}reference/elasticsearch/clients/go/getting-started`,
      httpApis: `${ELASTIC_DOCS}deploy-manage/deploy/elastic-cloud/tools-apis`,
      httpApiReferences: `${ELASTIC_DOCS}deploy-manage/deploy/elastic-cloud/tools-apis`,
      jsApiReference: `${ELASTIC_DOCS}reference/elasticsearch/clients/javascript/getting-started`,
      jsGettingStarted: `${ELASTIC_DOCS}reference/elasticsearch/clients/javascript/getting-started`,
      phpApiReference: `${ELASTIC_DOCS}reference/elasticsearch/clients/php/getting-started`,
      phpGettingStarted: `${ELASTIC_DOCS}reference/elasticsearch/clients/php/getting-started`,
      pythonApiReference: `${ELASTIC_DOCS}reference/elasticsearch/clients/python/getting-started`,
      pythonGettingStarted: `${ELASTIC_DOCS}reference/elasticsearch/clients/python/getting-started`,
      pythonReferences: `${ELASTIC_DOCS}reference/elasticsearch/clients/python/getting-started`,
      rubyApiReference: `${ELASTIC_DOCS}reference/elasticsearch/clients/ruby/getting-started`,
      rubyGettingStarted: `${ELASTIC_DOCS}reference/elasticsearch/clients/ruby/getting-started`
    },
    serverlessSearch: {
      integrations: `${ELASTIC_DOCS}manage-data/ingest`,
      integrationsLogstash: `${ELASTIC_DOCS}reference/logstash`,
      integrationsBeats: `${ELASTIC_DOCS}reference/beats`,
      integrationsConnectorClient: `${ELASTIC_DOCS}reference/search-connectors`,
      integrationsConnectorClientAvailableConnectors: `${ELASTIC_DOCS}reference/search-connectors#available-connectors`,
      integrationsConnectorClientRunFromSource: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-run-from-source`,
      integrationsConnectorClientRunWithDocker: `${ELASTIC_DOCS}reference/search-connectors/es-connectors-run-from-docker`,
      gettingStartedExplore: `${ELASTIC_DOCS}solutions/search/get-started`,
      gettingStartedIngest: `${ELASTIC_DOCS}solutions/search/ingest-for-search`,
      gettingStartedSearch: `${ELASTIC_DOCS}solutions/search/search-approaches`
    },
    serverlessSecurity: {
      apiKeyPrivileges: `${ELASTIC_DOCS}deploy-manage/api-keys/serverless-project-api-keys#api-keys-restrict-privileges`
    },
    synthetics: {
      featureRoles: `${ELASTIC_DOCS}solutions/observability/synthetics/grant-access-to-secured-resources`
    },
    telemetry: {
      settings: `${ELASTIC_DOCS}reference/kibana/configuration-reference/telemetry-settings`
    },
    playground: {
      chatPlayground: `${ELASTIC_DOCS}solutions/search/rag/playground`,
      retrievalOptimize: `${ELASTIC_DOCS}solutions/search/rag/playground-query#playground-query-relevance`,
      retrieval: `${ELASTIC_DOCS}solutions/search/rag/playground-query`,
      context: `${ELASTIC_DOCS}solutions/search/rag/playground-context`,
      hiddenFields: `${ELASTIC_DOCS}solutions/search/rag/playground-query#playground-hidden-fields`
    },
    agentBuilder: {
      agentBuilder: `${ELASTIC_DOCS}solutions/search/elastic-agent-builder`,
      getStarted: `${ELASTIC_DOCS}solutions/search/agent-builder/get-started`,
      models: `${ELASTIC_DOCS}solutions/search/agent-builder/models`,
      chat: `${ELASTIC_DOCS}solutions/search/agent-builder/chat`,
      agentBuilderAgents: `${ELASTIC_DOCS}solutions/search/agent-builder/agent-builder-agents`,
      tools: `${ELASTIC_DOCS}solutions/search/agent-builder/tools`,
      programmaticAccess: `${ELASTIC_DOCS}solutions/search/agent-builder/programmatic-access`,
      kibanaApi: `${ELASTIC_DOCS}solutions/search/agent-builder/kibana-api`,
      mcpServer: `${ELASTIC_DOCS}solutions/search/agent-builder/mcp-server`,
      a2aServer: `${ELASTIC_DOCS}solutions/search/agent-builder/a2a-server`,
      limitationsKnownIssues: `${ELASTIC_DOCS}solutions/search/agent-builder/limitations-known-issues`,
      learnMore: `${ELASTIC_DOCS}explore-analyze/ai-features/ai-agent-or-ai-assistant`
    },
    inferenceManagement: {
      inferenceAPIDocumentation: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}operation/operation-inference-put` : `${ELASTICSEARCH_APIS}operation/operation-inference-put`
    },
    synonyms: {
      synonymsAPIDocumentation: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}group/endpoint-synonyms` : `${ELASTICSEARCH_APIS}group/endpoint-synonyms`
    },
    queryRules: {
      queryRulesAPIDocumentation: isServerless ? `${ELASTICSEARCH_SERVERLESS_APIS}group/endpoint-query_rules` : `${ELASTICSEARCH_APIS}group/endpoint-query_rules`
    },
    datasetQuality: {
      failureStore: `${ELASTIC_DOCS}solutions/observability/data-set-quality-monitoring#find-failed-documents-with-failure-store`
    },
    indexManagement: {
      componentTemplate: `${ELASTIC_DOCS}manage-data/data-store/templates#component-templates`,
      indexAlias: `${ELASTIC_DOCS}manage-data/data-store/aliases`
    }
  });
};
exports.getDocLinks = getDocLinks;