"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReviewFields = getReviewFields;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generates an object of fields with their example values and positions
 * for LLM review and ECS field mapping.
 */
function getReviewFields(pattern, numExamples = 5) {
  return pattern.fields.reduce((reviewFields, field) => {
    var _field$modifiers;
    // Skip empty/skip fields
    if (!((_field$modifiers = field.modifiers) !== null && _field$modifiers !== void 0 && _field$modifiers.skip)) {
      reviewFields[field.name] = {
        example_values: (0, _lodash.uniq)(field.values).slice(0, numExamples),
        position: field.position
      };
    }
    return reviewFields;
  }, {});
}

/**
 * Result from LLM review of dissect fields where ECS field names have already been mapped to OpenTelemetry fields.
 */