"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedFields = getFormattedFields;
var _format_value = require("./format_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getFormattedFields(doc, fields, {
  dataView,
  fieldFormats
}) {
  const formatField = field => {
    const fieldStr = field;
    return doc.flattened[fieldStr] !== undefined && doc.flattened[fieldStr] !== null ? (0, _format_value.formatFieldValue)(doc.flattened[fieldStr], doc.raw, fieldFormats, dataView, dataView.fields.getByName(fieldStr)) : undefined;
  };
  return fields.reduce((acc, field) => {
    acc[field] = formatField(field);
    return acc;
  }, {});
}