"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertValueToString = void 0;
var _common = require("@kbn/data-plugin/common");
var _format_value = require("./format_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const separator = ',';
const convertValueToString = ({
  dataView,
  dataViewField,
  flattenedValue,
  dataTableRecord,
  fieldFormats,
  options
}) => {
  var _ref, _options$compatibleWi;
  const disableMultiline = (_ref = (options === null || options === void 0 ? void 0 : options.compatibleWithMarkdown) || (options === null || options === void 0 ? void 0 : options.compatibleWithCSV)) !== null && _ref !== void 0 ? _ref : false;
  if ((dataViewField === null || dataViewField === void 0 ? void 0 : dataViewField.type) === '_source') {
    return {
      formattedString: stringify(dataTableRecord.flattened, disableMultiline),
      withFormula: false
    };
  }
  const valuesArray = Array.isArray(flattenedValue) ? flattenedValue : [flattenedValue];
  const enableEscapingForValue = (_options$compatibleWi = options === null || options === void 0 ? void 0 : options.compatibleWithCSV) !== null && _options$compatibleWi !== void 0 ? _options$compatibleWi : false;
  let withFormula = false;
  const formatted = valuesArray.map(subValue => {
    const formattedValue = (0, _format_value.formatFieldValue)(subValue, dataTableRecord.raw, fieldFormats, dataView, dataViewField, 'text', {
      skipFormattingInStringifiedJSON: disableMultiline
    });
    if (typeof formattedValue === 'string') {
      withFormula = withFormula || (0, _common.cellHasFormulas)(formattedValue);
      return enableEscapingForValue ? escapeFormattedValue(formattedValue) : formattedValue;
    }
    return stringify(formattedValue, disableMultiline) || '';
  }).join(`${separator} `);
  return {
    formattedString: formatted,
    withFormula: options !== null && options !== void 0 && options.compatibleWithMarkdown ? false : withFormula
  };
};
exports.convertValueToString = convertValueToString;
const stringify = (val, disableMultiline) => {
  // it can wrap "strings" with quotes
  return disableMultiline ? JSON.stringify(val) : JSON.stringify(val, null, 2);
};
const escapeValueFn = (0, _common.createEscapeValue)({
  separator,
  quoteValues: true,
  escapeFormulaValues: true
});
const escapeFormattedValue = formattedValue => {
  return escapeValueFn(formattedValue);
};