"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.titleFromLocatorFactory = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @internal
 */
const titleFromLocatorFactory = services => {
  /**
   * Allows consumers to derive a title of a search in Disocver from DiscoverAppLocatorParams.
   * For now, this assumes the DiscoverAppLocatorParams contain a reference to a saved search. In the future,
   * the params may only contain a reference to a DataView
   *
   * @public
   */
  const titleFromLocator = async params => {
    var _searchObject$attribu;
    const {
      savedSearchId,
      title: paramsTitle
    } = params;
    if (paramsTitle) {
      return paramsTitle;
    }
    if (!savedSearchId) {
      throw new Error(`DiscoverAppLocatorParams must contain a saved search reference`);
    }
    const {
      savedObjects
    } = services;
    const searchObject = await savedObjects.get('search', savedSearchId // assumes params contains saved search reference
    );
    return (_searchObject$attribu = searchObject.attributes.title) !== null && _searchObject$attribu !== void 0 ? _searchObject$attribu : _i18n.i18n.translate('discover.serverLocatorExtension.titleFromLocatorUnknown', {
      defaultMessage: 'Unknown search'
    });
  };
  return titleFromLocator;
};
exports.titleFromLocatorFactory = titleFromLocatorFactory;