"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomizationService = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createCustomizationService = () => {
  const update$ = new _rxjs.Subject();
  const customizations = new Map();
  const getCustomization = id => {
    const entry = customizations.get(id);
    if (entry && entry.enabled) {
      return entry.customization;
    }
  };
  return {
    set: customization => {
      var _entry$enabled;
      const entry = customizations.get(customization.id);
      customizations.set(customization.id, {
        customization,
        enabled: (_entry$enabled = entry === null || entry === void 0 ? void 0 : entry.enabled) !== null && _entry$enabled !== void 0 ? _entry$enabled : true
      });
      update$.next(customization.id);
    },
    get: getCustomization,
    get$: id => {
      return update$.pipe((0, _rxjs.startWith)(id), (0, _rxjs.filter)(currentId => currentId === id), (0, _rxjs.map)(() => getCustomization(id)));
    },
    enable: id => {
      const entry = customizations.get(id);
      if (entry && !entry.enabled) {
        entry.enabled = true;
        update$.next(entry.customization.id);
      }
    },
    disable: id => {
      const entry = customizations.get(id);
      if (entry && entry.enabled) {
        entry.enabled = false;
        update$.next(entry.customization.id);
      }
    }
  };
};
exports.createCustomizationService = createCustomizationService;