"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTracesOtelDataSourceProfileProvider = void 0;
var _constants = require("../../../../../../common/data_types/logs/constants");
var _profiles = require("../../../../profiles");
var _extend_profile_provider = require("../../../extend_profile_provider");
var _extract_index_pattern_from = require("../../../extract_index_pattern_from");
var _chart_section = require("../accessors/chart_section");
var _reg_exps = require("./reg_exps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createTracesOtelDataSourceProfileProvider = tracesDataSourceProfileProvider => {
  const resolve = async params => {
    const baseResult = await tracesDataSourceProfileProvider.resolve(params);
    if (!baseResult.isMatch) {
      return baseResult;
    }
    const indexPattern = (0, _extract_index_pattern_from.extractIndexPatternFrom)(params);
    const isOtelIndexPattern = _reg_exps.reContainsTracesOtel.test(indexPattern || '');
    const isApmIndexPattern = _reg_exps.reContainsTracesApm.test(indexPattern || '');

    // Avoid mixing APM and OTEL columns in the same profile
    if (isOtelIndexPattern && !isApmIndexPattern) {
      return {
        isMatch: true,
        context: {
          category: _profiles.DataSourceCategory.Traces
        }
      };
    }
    return {
      isMatch: false
    };
  };
  return (0, _extend_profile_provider.extendProfileProvider)(tracesDataSourceProfileProvider, {
    profileId: 'observability-traces-otel-data-source-profile',
    profile: {
      getDefaultAppState: () => () => {
        return {
          columns: [{
            name: _constants.TIMESTAMP_FIELD,
            width: 212
          }, {
            name: _constants.SERVICE_NAME_FIELD
          }, {
            name: _constants.SPAN_NAME_FIELD
          }, {
            name: _constants.OTEL_DURATION
          }, {
            name: _constants.OTEL_SPAN_KIND
          }, {
            name: _constants.OTEL_STATUS_CODE
          }],
          rowHeight: 1
        };
      },
      getChartSectionConfiguration: (0, _chart_section.createChartSection)('otel')
    },
    resolve
  });
};
exports.createTracesOtelDataSourceProfileProvider = createTracesOtelDataSourceProfileProvider;