"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractIndexPatternFrom = void 0;
var _esQuery = require("@kbn/es-query");
var _esqlUtils = require("@kbn/esql-utils");
var _data_sources = require("../../../common/data_sources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Extracts the index pattern from the given ES|QL query or data view
 * @param options Options object
 * @returns The extracted index pattern or null
 */
const extractIndexPatternFrom = ({
  dataSource,
  dataView,
  query
}) => {
  if ((0, _data_sources.isEsqlSource)(dataSource) && (0, _esQuery.isOfAggregateQueryType)(query)) {
    return (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
  } else if ((0, _data_sources.isDataViewSource)(dataSource) && dataView) {
    return dataView.getIndexPattern();
  }
  return null;
};
exports.extractIndexPatternFrom = extractIndexPatternFrom;