"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resetDiscoverSession = void 0;
var _internal_state = require("../internal_state");
var _runtime_state = require("../runtime_state");
var _selectors = require("../selectors");
var _tab_mapping_utils = require("../tab_mapping_utils");
var _utils = require("../utils");
var _data_views = require("./data_views");
var _tabs = require("./tabs");
var _get_initial_app_state = require("../../utils/get_initial_app_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const resetDiscoverSession = exports.resetDiscoverSession = (0, _utils.createInternalStateAsyncThunk)('internalState/resetDiscoverSession', async ({
  updatedDiscoverSession,
  nextSelectedTabId
} = {}, {
  dispatch,
  getState,
  extra: {
    services,
    runtimeStateManager
  }
}) => {
  var _allTabs$find;
  const state = getState();
  const discoverSession = updatedDiscoverSession !== null && updatedDiscoverSession !== void 0 ? updatedDiscoverSession : state.persistedDiscoverSession;
  if (!discoverSession) {
    return;
  }

  // If an updated session is provided, we know it has just been saved and all tab state is up to date.
  // Otherwise we're resetting the current session, and need to detect changes to mark tabs for refetch.
  const unsavedTabIds = updatedDiscoverSession ? [] : state.tabs.unsavedIds;
  const selectedTabId = nextSelectedTabId !== null && nextSelectedTabId !== void 0 ? nextSelectedTabId : state.tabs.unsafeCurrentId;
  const allTabs = await Promise.all(discoverSession.tabs.map(async tab => {
    dispatch(_internal_state.internalStateSlice.actions.resetOnSavedSearchChange({
      tabId: tab.id
    }));
    const tabRuntimeState = (0, _runtime_state.selectTabRuntimeState)(runtimeStateManager, tab.id);
    const tabStateContainer = tabRuntimeState === null || tabRuntimeState === void 0 ? void 0 : tabRuntimeState.stateContainer$.getValue();
    let initialAppState;
    if (tabStateContainer) {
      const savedSearch = await (0, _tab_mapping_utils.fromSavedObjectTabToSavedSearch)({
        tab,
        discoverSession,
        services
      });
      const dataView = savedSearch.searchSource.getField('index');
      if (dataView) {
        dispatch((0, _data_views.setDataView)({
          tabId: tab.id,
          dataView
        }));
      }
      tabStateContainer.savedSearchState.set(savedSearch);
      initialAppState = (0, _get_initial_app_state.getInitialAppState)({
        initialUrlState: undefined,
        persistedTab: tab,
        dataView,
        services
      });
    }
    const tabState = (0, _tab_mapping_utils.fromSavedObjectTabToTabState)({
      tab,
      existingTab: (0, _selectors.selectTab)(state, tab.id),
      initialAppState
    });

    // If the tab had changes, we force-fetch when selecting it so the data matches the UI state.
    // We don't need to do this for the current tab since it's already being synced.
    if (tab.id !== selectedTabId && unsavedTabIds.includes(tab.id)) {
      tabState.forceFetchOnSelect = true;
    }
    return tabState;
  }));
  const selectedTab = (_allTabs$find = allTabs.find(tab => tab.id === selectedTabId)) !== null && _allTabs$find !== void 0 ? _allTabs$find : allTabs[0];
  await dispatch((0, _tabs.updateTabs)({
    items: allTabs,
    selectedItem: selectedTab,
    updatedDiscoverSession
  }));
});