"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchOccurrencesRange = exports.TimeRangeExtendingStatus = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _common2 = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let TimeRangeExtendingStatus = exports.TimeRangeExtendingStatus = /*#__PURE__*/function (TimeRangeExtendingStatus) {
  TimeRangeExtendingStatus["initial"] = "initial";
  TimeRangeExtendingStatus["loading"] = "loading";
  TimeRangeExtendingStatus["succeedWithResults"] = "succeedWithResults";
  TimeRangeExtendingStatus["succeedWithoutResults"] = "succeedWithoutResults";
  TimeRangeExtendingStatus["failed"] = "failed";
  TimeRangeExtendingStatus["timedOut"] = "timedOut";
  return TimeRangeExtendingStatus;
}({});
const useFetchOccurrencesRange = params => {
  const data = params.services.data;
  const uiSettings = params.services.uiSettings;
  const abortControllerRef = (0, _react.useRef)(null);
  const mountedRef = (0, _react.useRef)(true);
  const fetchOccurrences = (0, _react.useCallback)(async (dataView, query, filters) => {
    let occurrencesRangeResult = {
      status: TimeRangeExtendingStatus.failed
    };
    if (dataView !== null && dataView !== void 0 && dataView.isTimeBased() && query && mountedRef.current) {
      var _abortControllerRef$c;
      (_abortControllerRef$c = abortControllerRef.current) === null || _abortControllerRef$c === void 0 ? void 0 : _abortControllerRef$c.abort(_common2.AbortReason.REPLACED);
      abortControllerRef.current = new AbortController();
      try {
        var _abortControllerRef$c2;
        const dslQuery = (0, _esQuery.buildEsQuery)(dataView, query !== null && query !== void 0 ? query : [], filters !== null && filters !== void 0 ? filters : [], (0, _common.getEsQueryConfig)(uiSettings));
        occurrencesRangeResult = await fetchDocumentsTimeRange({
          data,
          dataView,
          dslQuery,
          abortSignal: (_abortControllerRef$c2 = abortControllerRef.current) === null || _abortControllerRef$c2 === void 0 ? void 0 : _abortControllerRef$c2.signal
        });
      } catch (error) {
        if (error.name !== 'AbortError') {
          // eslint-disable-next-line no-console
          console.error(error);
        }
      }
    }
    return occurrencesRangeResult;
  }, [abortControllerRef, mountedRef, data, uiSettings]);
  (0, _react.useEffect)(() => {
    return () => {
      var _abortControllerRef$c3;
      mountedRef.current = false;
      (_abortControllerRef$c3 = abortControllerRef.current) === null || _abortControllerRef$c3 === void 0 ? void 0 : _abortControllerRef$c3.abort(_common2.AbortReason.CLEANUP);
    };
  }, [abortControllerRef, mountedRef]);
  return {
    fetch: () => fetchOccurrences(params.dataView, params.query, params.filters)
  };
};
exports.useFetchOccurrencesRange = useFetchOccurrencesRange;
async function fetchDocumentsTimeRange({
  data,
  dataView,
  dslQuery,
  abortSignal
}) {
  var _result$rawResponse, _result$rawResponse2, _result$rawResponse2$, _result$rawResponse3, _result$rawResponse3$, _result$rawResponse4, _result$rawResponse4$, _result$rawResponse5, _result$rawResponse5$, _result$rawResponse6, _result$rawResponse6$, _result$rawResponse6$2, _result$rawResponse7, _result$rawResponse7$, _result$rawResponse7$2;
  if (!(dataView !== null && dataView !== void 0 && dataView.timeFieldName)) {
    return {
      status: TimeRangeExtendingStatus.failed
    };
  }
  const result = await (0, _rxjs.lastValueFrom)(data.search.search({
    params: {
      index: dataView.getIndexPattern(),
      size: 0,
      track_total_hits: false,
      timeout: '20s',
      query: dslQuery !== null && dslQuery !== void 0 ? dslQuery : {
        match_all: {}
      },
      aggs: {
        earliest_timestamp: {
          min: {
            field: dataView.timeFieldName,
            format: 'strict_date_optional_time'
          }
        },
        latest_timestamp: {
          max: {
            field: dataView.timeFieldName,
            format: 'strict_date_optional_time'
          }
        }
      }
    }
  }, {
    abortSignal
  }));
  if ((_result$rawResponse = result.rawResponse) !== null && _result$rawResponse !== void 0 && _result$rawResponse.timed_out) {
    return {
      status: TimeRangeExtendingStatus.timedOut
    };
  }
  if (((_result$rawResponse2 = result.rawResponse) === null || _result$rawResponse2 === void 0 ? void 0 : (_result$rawResponse2$ = _result$rawResponse2._clusters) === null || _result$rawResponse2$ === void 0 ? void 0 : _result$rawResponse2$.total) !== ((_result$rawResponse3 = result.rawResponse) === null || _result$rawResponse3 === void 0 ? void 0 : (_result$rawResponse3$ = _result$rawResponse3._clusters) === null || _result$rawResponse3$ === void 0 ? void 0 : _result$rawResponse3$.successful) || ((_result$rawResponse4 = result.rawResponse) === null || _result$rawResponse4 === void 0 ? void 0 : (_result$rawResponse4$ = _result$rawResponse4._shards) === null || _result$rawResponse4$ === void 0 ? void 0 : _result$rawResponse4$.total) !== ((_result$rawResponse5 = result.rawResponse) === null || _result$rawResponse5 === void 0 ? void 0 : (_result$rawResponse5$ = _result$rawResponse5._shards) === null || _result$rawResponse5$ === void 0 ? void 0 : _result$rawResponse5$.successful)) {
    return {
      status: TimeRangeExtendingStatus.failed
    };
  }
  const earliestTimestamp = (_result$rawResponse6 = result.rawResponse) === null || _result$rawResponse6 === void 0 ? void 0 : (_result$rawResponse6$ = _result$rawResponse6.aggregations) === null || _result$rawResponse6$ === void 0 ? void 0 : (_result$rawResponse6$2 = _result$rawResponse6$.earliest_timestamp) === null || _result$rawResponse6$2 === void 0 ? void 0 : _result$rawResponse6$2.value_as_string;
  const latestTimestamp = (_result$rawResponse7 = result.rawResponse) === null || _result$rawResponse7 === void 0 ? void 0 : (_result$rawResponse7$ = _result$rawResponse7.aggregations) === null || _result$rawResponse7$ === void 0 ? void 0 : (_result$rawResponse7$2 = _result$rawResponse7$.latest_timestamp) === null || _result$rawResponse7$2 === void 0 ? void 0 : _result$rawResponse7$2.value_as_string;
  return earliestTimestamp && latestTimestamp ? {
    status: TimeRangeExtendingStatus.succeedWithResults,
    range: {
      from: earliestTimestamp,
      to: latestTimestamp
    }
  } : {
    status: TimeRangeExtendingStatus.succeedWithoutResults
  };
}