"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractNonAggregatableDatasets = void 0;
var _utils = require("../../../../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractNonAggregatableDatasets = (indices, nonAggregatableIndices) => {
  const groupedDatasets = (Array.isArray(indices) ? indices : [indices]).reduce((acc, index) => {
    var _acc$dataset;
    const dataset = (0, _utils.extractIndexNameFromBackingIndex)(index);
    return {
      ...acc,
      [dataset]: [...((_acc$dataset = acc[dataset]) !== null && _acc$dataset !== void 0 ? _acc$dataset : []), index]
    };
  }, {});
  const groupedNonAggregatableIndices = (Array.isArray(nonAggregatableIndices) ? nonAggregatableIndices : [nonAggregatableIndices]).reduce((acc, index) => {
    var _acc$dataset2;
    const dataset = (0, _utils.extractIndexNameFromBackingIndex)(index);
    return {
      ...acc,
      [dataset]: [...((_acc$dataset2 = acc[dataset]) !== null && _acc$dataset2 !== void 0 ? _acc$dataset2 : []), index]
    };
  }, {});
  return Object.entries(groupedNonAggregatableIndices).filter(([dataset, datasetIndices]) => {
    var _groupedDatasets$data;
    return ((_groupedDatasets$data = groupedDatasets[dataset]) === null || _groupedDatasets$data === void 0 ? void 0 : _groupedDatasets$data.length) <= datasetIndices.length;
  }).map(([dataset]) => dataset).flat();
};
exports.extractNonAggregatableDatasets = extractNonAggregatableDatasets;